<?php
/**
 * ERE Subscription API
 *
 * Handles subscription verification and scheduling.
 *
 * @package easy-real-estate/functions
 */
if ( ! class_exists( 'ERE_Subscription_API' ) ) {
	class ERE_Subscription_API {

		public $subscription_id;

		static $status;

		public function __construct() {

			$this->subscription_id = new ERE_Purchase_API();

			if ( ! wp_next_scheduled( 'ere_subscription_api' ) ) {
				wp_schedule_event( time(), 'ere-subscription-interval', 'ere_subscription_api' );
			}

			add_filter( 'cron_schedules', array( $this, 'subscription_recurrence' ) );
			add_filter( 'ere_subscription_api', array( $this, 'subscription_registration' ) );

			self::$status = $this->subscription_id::status();
		}

		static function status() {
			return self::$status;
		}

		public function subscription_registration() {

			$existing_purchase_code = get_option( 'envato_purchase_code_5373914' );
			$existing_username      = get_option( 'envato_username_5373914' );

			// If purchase code or username is missing, reset registration
			if ( empty( $existing_purchase_code ) || empty( $existing_username ) ) {
				delete_option( 'inspiry_realhomes_registered' );
				return;
			}

			// Verify purchase with both code and username enforced
			$item_purchase = $this->subscription_id->verify_purchase_code( $existing_purchase_code, $existing_username );

			if ( is_wp_error( $item_purchase ) || true !== $item_purchase ) {

				$verification_attempt = get_option( 'ere_subscription_attempt', 'ere-subscription-interval' );
				if ( empty( $verification_attempt ) || 'ere-subscription-interval' === $verification_attempt ) {
					update_option( 'ere_subscription_attempt', 'first_24hrs' );
					wp_clear_scheduled_hook( 'ere_subscription_api' );
					wp_schedule_event( strtotime( '10am tomorrow' ), 'daily', 'ere_subscription_api' );
				} else if ( 'first_24hrs' === $verification_attempt ) {
					update_option( 'ere_subscription_attempt', 'second_24hrs' );
					wp_clear_scheduled_hook( 'ere_subscription_api' );
					wp_schedule_event( strtotime( '10am tomorrow' ), 'daily', 'ere_subscription_api' );
				} else if ( 'second_24hrs' === $verification_attempt ) {
					update_option( 'ere_subscription_attempt', 'reset_data' );
					wp_clear_scheduled_hook( 'ere_subscription_api' );
					wp_schedule_event( strtotime( '10am tomorrow' ), 'daily', 'ere_subscription_api' );
				} else {
					// Final failure → reset everything
					delete_option( 'envato_purchase_code_5373914' );
					delete_option( 'envato_username_5373914' );
					delete_option( 'inspiry_realhomes_registered' );
					update_option( 'ere_subscription_attempt', 'ere-subscription-interval' );
					update_option( 'realhomes_verification_attempt_notice', 'true' );
					wp_clear_scheduled_hook( 'ere_subscription_api' );
				}
			}
		}

		public function subscription_recurrence( $schedules ) {
			$schedules['ere-subscription-interval'] = array(
				'display'  => esc_html__( 'ERE Subscription Interval', ERE_TEXT_DOMAIN ),
				'interval' => 604800,
			);
			return $schedules;
		}
	}

	/** Initialize ERE Subscription API */
	new ERE_Subscription_API();
}