<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$theme_show_reCAPTCHA        = $this->get_option( 'theme_show_reCAPTCHA', 'false' );
$theme_recaptcha_public_key  = $this->get_option( 'theme_recaptcha_public_key' );
$theme_recaptcha_private_key = $this->get_option( 'theme_recaptcha_private_key' );
$theme_recaptcha_type        = $this->get_option( 'inspiry_reCAPTCHA_type', 'v2' );
$recaptcha_badge             = $this->get_option( 'ere_display_recaptcha_badge', 'show' );

if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {
	update_option( 'theme_show_reCAPTCHA', $theme_show_reCAPTCHA );
	update_option( 'theme_recaptcha_public_key', $theme_recaptcha_public_key );
	update_option( 'theme_recaptcha_private_key', $theme_recaptcha_private_key );
	update_option( 'inspiry_reCAPTCHA_type', $theme_recaptcha_type );
	update_option( 'ere_display_recaptcha_badge', $recaptcha_badge );
}
?>
<div class="inspiry-ere-page-content">
    <div class="description">
        <p><?php esc_html_e( 'For spam protection on agent and contact forms!', ERE_TEXT_DOMAIN ); ?></p>
    </div>
    <form method="post" action="" novalidate="novalidate">

        <div class="main-options-wrap">
            <div class="left">
                <h4><?php esc_html_e( 'Google reCAPTCHA', ERE_TEXT_DOMAIN ); ?></h4>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Google reCAPTCHA', ERE_TEXT_DOMAIN ); ?></span>
                </legend>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <span class="allow">
                        <input type="radio" id="theme_show_reCAPTCHA_true" name="theme_show_reCAPTCHA" value="true" <?php checked( $theme_show_reCAPTCHA, 'true' ); ?>>
                        <label class="button-primary" for="theme_show_reCAPTCHA_true"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="deny">
                        <input type="radio" id="theme_show_reCAPTCHA_false" name="theme_show_reCAPTCHA" value="false" <?php checked( $theme_show_reCAPTCHA, 'false' ); ?>>
                        <label class="button-primary" for="theme_show_reCAPTCHA_false"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                </p>
            </div>
        </div>

        <div class="main-options-wrap">
            <div class="left">
                <h4><?php esc_html_e( 'Google reCAPTCHA Type', ERE_TEXT_DOMAIN ); ?></h4>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Google reCAPTCHA Type', ERE_TEXT_DOMAIN ); ?></span>
                </legend>
                <p class="desc"><?php esc_html_e( 'Get new keys for V3 as V2 keys will not work!', ERE_TEXT_DOMAIN ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <span class="allow">
                        <input type="radio" id="inspiry_reCAPTCHA_type_v2" name="inspiry_reCAPTCHA_type" value="v2" <?php checked( $theme_recaptcha_type, 'v2' ); ?>>
                        <label class="button-primary" for="inspiry_reCAPTCHA_type_v2"><?php esc_html_e( '&nbsp; V2 &nbsp;', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="deny">
                        <input type="radio" id="inspiry_reCAPTCHA_type_v3" name="inspiry_reCAPTCHA_type" value="v3" <?php checked( $theme_recaptcha_type, 'v3' ); ?>>
                        <label class="button-primary" for="inspiry_reCAPTCHA_type_v3"><?php esc_html_e( '&nbsp; V3 &nbsp;', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                </p>
            </div>
        </div>

        <div class="main-options-wrap">
            <div class="left">
                <h4 for="theme_recaptcha_public_key"><?php esc_html_e( 'Site Key', ERE_TEXT_DOMAIN ); ?></h4>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Site Key', ERE_TEXT_DOMAIN ); ?></span>
                </legend>
                <p class="desc"><?php printf( esc_html__( 'You can get new keys for your website by %s signing in here %s', ERE_TEXT_DOMAIN ), '<a href="https://www.google.com/recaptcha/admin#whyrecaptcha" target="_blank">', '</a>' ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <input name="theme_recaptcha_public_key" type="text" id="theme_recaptcha_public_key" value="<?php echo esc_attr( $theme_recaptcha_public_key ); ?>" class="regular-text code">
                </p>
            </div>
        </div>

        <div class="main-options-wrap">
            <div class="left">
                <h4 for="theme_recaptcha_public_key"><?php esc_html_e( 'Secret Key', ERE_TEXT_DOMAIN ); ?></h4>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Secret Key', ERE_TEXT_DOMAIN ); ?></span>
                </legend>
            </div>
            <div class="right">
                <p>
                    <input name="theme_recaptcha_private_key" type="text" id="theme_recaptcha_private_key" value="<?php echo esc_attr( $theme_recaptcha_private_key ); ?>" class="regular-text code">
                </p>
            </div>
        </div>

        <div class="main-options-wrap">
            <div class="left">
                <h4><?php esc_html_e( 'Show reCaptcha Badge', ERE_TEXT_DOMAIN ); ?></h4>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Show reCaptcha Badge', ERE_TEXT_DOMAIN ); ?></span>
                </legend>
                <p class="desc"><?php esc_html_e( 'Applicable for only reCaptcha V3 badge.', ERE_TEXT_DOMAIN ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <span class="allow">
                        <input type="radio" id="ere_display_recaptcha_badge_show" name="ere_display_recaptcha_badge" value="show" <?php checked( $recaptcha_badge, 'show' ); ?>>
                        <label class="button-primary" for="ere_display_recaptcha_badge_show"><?php esc_html_e( 'Show', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="deny">
                        <input type="radio" id="ere_display_recaptcha_badge_hide" name="ere_display_recaptcha_badge" value="hide" <?php checked( $recaptcha_badge, 'hide' ); ?>>
                        <label class="button-primary" for="ere_display_recaptcha_badge_hide"><?php esc_html_e( 'Hide', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                </p>
            </div>
        </div>

        <div class="submit">
			<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
            <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
        </div>
    </form>
</div>