<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$theme_currency_sign              = $this->get_option( 'theme_currency_sign', '$' );
$ere_currency_sign_space          = $this->get_option( 'ere_currency_sign_space', 'none' );
$theme_currency_position          = $this->get_option( 'theme_currency_position', 'before' );
$theme_decimals                   = $this->get_option( 'theme_decimals', '0' );
$theme_dec_point                  = $this->get_option( 'theme_dec_point', '.' );
$theme_thousands_sep              = $this->get_option( 'theme_thousands_sep', ',' );
$theme_no_price_text              = $this->get_option( 'theme_no_price_text' );
$ere_price_number_format_language = $this->get_option( 'ere_price_number_format_language', 'en-US' );
$ere_price_prefix                 = $this->get_option( 'ere_price_prefix' );
$ere_price_postfix                = $this->get_option( 'ere_price_postfix' );
$ere_property_dual_price_status   = $this->get_option( 'ere_property_dual_price_status', 'disable' );

if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {
	update_option( 'theme_currency_sign', $theme_currency_sign );
	update_option( 'ere_currency_sign_space', $ere_currency_sign_space );
	update_option( 'theme_currency_position', $theme_currency_position );
	update_option( 'theme_decimals', $theme_decimals );
	update_option( 'theme_dec_point', $theme_dec_point );
	update_option( 'theme_thousands_sep', $theme_thousands_sep );
	update_option( 'theme_no_price_text', $theme_no_price_text );
	update_option( 'ere_price_number_format_language', $ere_price_number_format_language );
	update_option( 'ere_price_prefix', $ere_price_prefix );
	update_option( 'ere_price_postfix', $ere_price_postfix );
	update_option( 'ere_property_dual_price_status', $ere_property_dual_price_status );
}
?>
<div class="inspiry-ere-page-content">

    <form method="post" action="" novalidate="novalidate">

        <div class="main-options-wrap">
		    <?php
		    $currency_sign_field_title = esc_html__( 'Currency Sign', ERE_TEXT_DOMAIN );
		    $currency_sign_field_description = esc_html__( 'Select if you want to have space before or after the currency sign.', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $currency_sign_field_title ); ?>"><?php echo esc_html( $currency_sign_field_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $currency_sign_field_description ); ?>"><?php echo esc_html( $currency_sign_field_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="theme_currency_sign" type="text" id="theme_currency_sign" value="<?php echo esc_attr( $theme_currency_sign ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $currency_sign_position_title = esc_html__( 'Position of Currency Sign', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $currency_sign_position_title ); ?>"><?php echo esc_html( $currency_sign_position_title ); ?></h4>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <span class="none">
                        <input type="radio" id="ere_currency_sign_position_before" name="theme_currency_position" value="before" <?php checked( $theme_currency_position, 'before' ) ?>>
                        <label class="button-primary" for="ere_currency_sign_position_before"><?php esc_html_e( 'Before the numbers', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="before">
                        <input type="radio" id="ere_currency_sign_position_after" name="theme_currency_position" value="after" <?php checked( $theme_currency_position, 'after' ) ?>>
                        <label class="button-primary" for="ere_currency_sign_position_after"><?php esc_html_e( 'After the numbers', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $space_with_currency_title       = esc_html__( 'Space with currency sign', ERE_TEXT_DOMAIN );
		    $space_with_currency_description = esc_html__( 'Select if you want to have space before or after the currency sign.', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $space_with_currency_title ); ?>"><?php echo esc_html( $space_with_currency_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $space_with_currency_description ); ?>"><?php echo esc_html( $space_with_currency_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-radio-option">
                    <span class="none">
                        <input type="radio" id="ere_currency_sign_space_none" name="ere_currency_sign_space" value="none" <?php checked( $ere_currency_sign_space, 'none' ) ?>>
                        <label class="button-primary" for="ere_currency_sign_space_none"><?php esc_html_e( 'None', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="before">
                        <input type="radio" id="ere_currency_sign_space_before" name="ere_currency_sign_space" value="before" <?php checked( $ere_currency_sign_space, 'before' ) ?>>
                        <label class="button-primary" for="ere_currency_sign_space_before"><?php esc_html_e( 'Before', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                    <span class="after">
                        <input type="radio" id="ere_currency_sign_space_after" name="ere_currency_sign_space" value="after" <?php checked( $ere_currency_sign_space, 'after' ) ?>>
                        <label class="button-primary" for="ere_currency_sign_space_after"><?php esc_html_e( 'After', ERE_TEXT_DOMAIN ); ?></label>
                    </span>
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $number_of_decimals_title = esc_html__( 'Number of Decimals Points', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $number_of_decimals_title ); ?>"><?php echo esc_html( $number_of_decimals_title ); ?></h4>
            </div>
            <div class="right">
                <p class="fancy-select-field">
                    <select name="theme_decimals" id="theme_decimals">
                        <option value="0"<?php selected( $theme_decimals, '0' ); ?>><?php esc_html_e( '0', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="1"<?php selected( $theme_decimals, '1' ); ?>><?php esc_html_e( '1', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="2"<?php selected( $theme_decimals, '2' ); ?>><?php esc_html_e( '2', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="3"<?php selected( $theme_decimals, '3' ); ?>><?php esc_html_e( '3', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="4"<?php selected( $theme_decimals, '4' ); ?>><?php esc_html_e( '4', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="5"<?php selected( $theme_decimals, '5' ); ?>><?php esc_html_e( '5', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="6"<?php selected( $theme_decimals, '6' ); ?>><?php esc_html_e( '6', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="7"<?php selected( $theme_decimals, '7' ); ?>><?php esc_html_e( '7', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="8"<?php selected( $theme_decimals, '8' ); ?>><?php esc_html_e( '8', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="9"<?php selected( $theme_decimals, '9' ); ?>><?php esc_html_e( '9', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="10"<?php selected( $theme_decimals, '10' ); ?>><?php esc_html_e( '10', ERE_TEXT_DOMAIN ); ?></option>
                    </select>
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $decimal_point_separator_title = esc_html__( 'Decimal Point Separator', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $decimal_point_separator_title ); ?>"><?php echo esc_html( $decimal_point_separator_title ); ?></h4>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="theme_dec_point" type="text" id="theme_dec_point" value="<?php echo esc_attr( $theme_dec_point ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $thousand_separator_title = esc_html__( 'Thousands Separator', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $thousand_separator_title ); ?>"><?php echo esc_html( $thousand_separator_title ); ?></h4>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="theme_thousands_sep" type="text" id="theme_thousands_sep" value="<?php echo esc_attr( $theme_thousands_sep ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $price_prefix_title       = esc_html__( 'Price Prefix', ERE_TEXT_DOMAIN );
		    $price_prefix_description = esc_html__( 'Example: From', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $price_prefix_title ); ?>"><?php echo esc_html( $price_prefix_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $price_prefix_description ); ?>"><?php echo esc_html( $price_prefix_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="ere_price_prefix" type="text" id="ere_price_prefix" value="<?php echo esc_attr( $ere_price_prefix ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $price_postfix_title       = esc_html__( 'Price Postfix', ERE_TEXT_DOMAIN );
		    $price_postfix_description = esc_html__( 'Example: Monthly or Per Night', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $price_postfix_title ); ?>"><?php echo esc_html( $price_postfix_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $price_postfix_description ); ?>"><?php echo esc_html( $price_postfix_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="ere_price_postfix" type="text" id="ere_price_postfix" value="<?php echo esc_attr( $ere_price_postfix ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    $empty_price_title       = esc_html__( 'Empty Price Text', ERE_TEXT_DOMAIN );
		    $empty_price_description = esc_html__( 'Text to display when no price is provided.', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $empty_price_title ); ?>"><?php echo esc_html( $empty_price_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $empty_price_description ); ?>"><?php echo esc_html( $empty_price_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-input-option">
                    <input name="theme_no_price_text" type="text" id="theme_no_price_text" value="<?php echo esc_attr( $theme_no_price_text ); ?>" class="regular-text code">
                </p>
            </div>
        </div>
        <br>

        <div class="main-options-wrap">
		    <?php
		    // List of language tags according to RFC 5646.
		    // See <http://tools.ietf.org/html/rfc5646> for info on how to parse these language tags.
		    $RFC5646_language_tags = array(
			    'ar-AE'      => 'Arabic (U.A.E.)',
			    'ar-BH'      => 'Arabic (Bahrain)',
			    'ar-DZ'      => 'Arabic (Algeria)',
			    'ar-EG'      => 'Arabic (Egypt)',
			    'ar-IQ'      => 'Arabic (Iraq)',
			    'ar-JO'      => 'Arabic (Jordan)',
			    'ar-KW'      => 'Arabic (Kuwait)',
			    'ar-LB'      => 'Arabic (Lebanon)',
			    'ar-LY'      => 'Arabic (Libya)',
			    'ar-MA'      => 'Arabic (Morocco)',
			    'ar-OM'      => 'Arabic (Oman)',
			    'ar-QA'      => 'Arabic (Qatar)',
			    'ar-SA'      => 'Arabic (Saudi Arabia)',
			    'ar-SY'      => 'Arabic (Syria)',
			    'ar-TN'      => 'Arabic (Tunisia)',
			    'ar-YE'      => 'Arabic (Yemen)',
			    'af-ZA'      => 'Afrikaans (South Africa)',
			    'az-AZ'      => 'Azeri (Latin) (Azerbaijan)',
			    'az-Cyrl-AZ' => 'Azeri (Cyrillic) (Azerbaijan)',
			    'be-BY'      => 'Belarusian (Belarus)',
			    'bg-BG'      => 'Bulgarian (Bulgaria)',
			    'bs-BA'      => 'Bosnian (Bosnia and Herzegovina)',
			    'ca-ES'      => 'Catalan (Spain)',
			    'cs-CZ'      => 'Czech (Czech Republic)',
			    'cy-GB'      => 'Welsh (United Kingdom)',
			    'da-DK'      => 'Danish (Denmark)',
			    'dv-MV'      => 'Divehi (Maldives)',
			    'en-US'      => 'English (United States)',
			    'en-AU'      => 'English (Australia)',
			    'en-BZ'      => 'English (Belize)',
			    'en-CA'      => 'English (Canada)',
			    'en-CB'      => 'English (Caribbean)',
			    'en-GB'      => 'English (United Kingdom)',
			    'en-IE'      => 'English (Ireland)',
			    'en-JM'      => 'English (Jamaica)',
			    'en-NZ'      => 'English (New Zealand)',
			    'en-PH'      => 'English (Republic of the Philippines)',
			    'en-TT'      => 'English (Trinidad and Tobago)',
			    'en-ZA'      => 'English (South Africa)',
			    'en-ZW'      => 'English (Zimbabwe)',
			    'de-AT'      => 'German (Austria)',
			    'de-CH'      => 'German (Switzerland)',
			    'de-DE'      => 'German (Germany)',
			    'de-LI'      => 'German (Liechtenstein)',
			    'de-LU'      => 'German (Luxembourg)',
			    'el-GR'      => 'Greek (Greece)',
			    'es-AR'      => 'Spanish (Argentina)',
			    'es-BO'      => 'Spanish (Bolivia)',
			    'es-CL'      => 'Spanish (Chile)',
			    'es-CO'      => 'Spanish (Colombia)',
			    'es-CR'      => 'Spanish (Costa Rica)',
			    'es-DO'      => 'Spanish (Dominican Republic)',
			    'es-EC'      => 'Spanish (Ecuador)',
			    'es-ES'      => 'Spanish (Spain)',
			    'es-GT'      => 'Spanish (Guatemala)',
			    'es-HN'      => 'Spanish (Honduras)',
			    'es-MX'      => 'Spanish (Mexico)',
			    'es-NI'      => 'Spanish (Nicaragua)',
			    'es-PA'      => 'Spanish (Panama)',
			    'es-PE'      => 'Spanish (Peru)',
			    'es-PR'      => 'Spanish (Puerto Rico)',
			    'es-PY'      => 'Spanish (Paraguay)',
			    'es-SV'      => 'Spanish (El Salvador)',
			    'es-UY'      => 'Spanish (Uruguay)',
			    'es-VE'      => 'Spanish (Venezuela)',
			    'et-EE'      => 'Estonian (Estonia)',
			    'eu-ES'      => 'Basque (Spain)',
			    'fa-IR'      => 'Farsi (Iran)',
			    'fi-FI'      => 'Finnish (Finland)',
			    'fo-FO'      => 'Faroese (Faroe Islands)',
			    'fr-BE'      => 'French (Belgium)',
			    'fr-CA'      => 'French (Canada)',
			    'fr-CH'      => 'French (Switzerland)',
			    'fr-FR'      => 'French (France)',
			    'fr-LU'      => 'French (Luxembourg)',
			    'fr-MC'      => 'French (Principality of Monaco)',
			    'gl-ES'      => 'Galician (Spain)',
			    'gu-IN'      => 'Gujarati (India)',
			    'he-IL'      => 'Hebrew (Israel)',
			    'hi-IN'      => 'Hindi (India)',
			    'hr-BA'      => 'Croatian (Bosnia and Herzegovina)',
			    'hr-HR'      => 'Croatian (Croatia)',
			    'hu-HU'      => 'Hungarian (Hungary)',
			    'hy-AM'      => 'Armenian (Armenia)',
			    'id-ID'      => 'Indonesian (Indonesia)',
			    'is-IS'      => 'Icelandic (Iceland)',
			    'it-CH'      => 'Italian (Switzerland)',
			    'it-IT'      => 'Italian (Italy)',
			    'ja-JP'      => 'Japanese (Japan)',
			    'ka-GE'      => 'Georgian (Georgia)',
			    'kk-KZ'      => 'Kazakh (Kazakhstan)',
			    'kn-IN'      => 'Kannada (India)',
			    'ko-KR'      => 'Korean (Korea)',
			    'kok-IN'     => 'Konkani (India)',
			    'ky-KG'      => 'Kyrgyz (Kyrgyzstan)',
			    'lt-LT'      => 'Lithuanian (Lithuania)',
			    'lv-LV'      => 'Latvian (Latvia)',
			    'mi-NZ'      => 'Maori (New Zealand)',
			    'mk-MK'      => 'FYRO Macedonian (Former Yugoslav Republic of Macedonia)',
			    'mn-MN'      => 'Mongolian (Mongolia)',
			    'mr-IN'      => 'Marathi (India)',
			    'ms-BN'      => 'Malay (Brunei Darussalam)',
			    'ms-MY'      => 'Malay (Malaysia)',
			    'mt-MT'      => 'Maltese (Malta)',
			    'nb-NO'      => 'Norwegian (Bokm?l) (Norway)',
			    'nl-BE'      => 'Dutch (Belgium)',
			    'nl-NL'      => 'Dutch (Netherlands)',
			    'nn-NO'      => 'Norwegian (Nynorsk) (Norway)',
			    'ns-ZA'      => 'Northern Sotho (South Africa)',
			    'pa-IN'      => 'Punjabi (India)',
			    'pl-PL'      => 'Polish (Poland)',
			    'ps-AR'      => 'Pashto (Afghanistan)',
			    'pt-BR'      => 'Portuguese (Brazil)',
			    'pt-PT'      => 'Portuguese (Portugal)',
			    'qu-BO'      => 'Quechua (Bolivia)',
			    'qu-EC'      => 'Quechua (Ecuador)',
			    'qu-PE'      => 'Quechua (Peru)',
			    'ro-RO'      => 'Romanian (Romania)',
			    'ru-RU'      => 'Russian (Russia)',
			    'sa-IN'      => 'Sanskrit (India)',
			    'se-FI'      => 'Sami (Finland)',
			    'se-NO'      => 'Sami (Norway)',
			    'se-SE'      => 'Sami (Sweden)',
			    'sk-SK'      => 'Slovak (Slovakia)',
			    'sl-SI'      => 'Slovenian (Slovenia)',
			    'sq-AL'      => 'Albanian (Albania)',
			    'sr-BA'      => 'Serbian (Latin) (Bosnia and Herzegovina)',
			    'sr-Cyrl-BA' => 'Serbian (Cyrillic) (Bosnia and Herzegovina)',
			    'sr-SP'      => 'Serbian (Latin) (Serbia and Montenegro)',
			    'sr-Cyrl-SP' => 'Serbian (Cyrillic) (Serbia and Montenegro)',
			    'sv-FI'      => 'Swedish (Finland)',
			    'sv-SE'      => 'Swedish (Sweden)',
			    'sw-KE'      => 'Swahili (Kenya)',
			    'syr-SY'     => 'Syriac (Syria)',
			    'ta-IN'      => 'Tamil (India)',
			    'te-IN'      => 'Telugu (India)',
			    'th-TH'      => 'Thai (Thailand)',
			    'tl-PH'      => 'Tagalog (Philippines)',
			    'tn-ZA'      => 'Tswana (South Africa)',
			    'tr-TR'      => 'Turkish (Turkey)',
			    'tt-RU'      => 'Tatar (Russia)',
			    'uk-UA'      => 'Ukrainian (Ukraine)',
			    'ur-PK'      => 'Urdu (Islamic Republic of Pakistan)',
			    'uz-UZ'      => 'Uzbek (Latin) (Uzbekistan)',
			    'uz-Cyrl-UZ' => 'Uzbek (Cyrillic) (Uzbekistan)',
			    'vi-VN'      => 'Vietnamese (Viet Nam)',
			    'xh-ZA'      => 'Xhosa (South Africa)',
			    'zh-CN'      => 'Chinese (S)',
			    'zh-HK'      => 'Chinese (Hong Kong)',
			    'zh-MO'      => 'Chinese (Macau)',
			    'zh-SG'      => 'Chinese (Singapore)',
			    'zh-TW'      => 'Chinese (T)',
			    'zu-ZA'      => 'Zulu (South Africa)'
		    );

		    // Holds the HTML markup.
		    $structure = array();

		    // sort the array in ascending order, according to the value.
		    asort( $RFC5646_language_tags );

		    // List RFC5646 languages tags.
		    foreach ( $RFC5646_language_tags as $tag => $language ) {
			    $structure[] = sprintf(
				    '<option value="%s"%s>%s</option>',
				    esc_attr( $tag ),
				    selected( $ere_price_number_format_language, $tag, false ),
				    esc_html( $language )
			    );
		    }

		    $output = '<select name="ere_price_number_format_language" id="ere_price_number_format_language">';
		    $output .= implode( "\n", $structure );
		    $output .= '</select>';

		    $price_preview_number_title       = esc_html__( 'Price Preview Number Format Language', ERE_TEXT_DOMAIN );
		    $price_preview_number_description = esc_html__( 'Change the property metabox price fields number format preview as per selected language.', ERE_TEXT_DOMAIN );
		    ?>
            <div class="left">
                <h4 aria-label="<?php echo esc_attr( $price_preview_number_title ); ?>"><?php echo esc_html( $price_preview_number_title ); ?></h4>
                <p class="description" aria-description="<?php echo esc_attr( $price_preview_number_description ); ?>"><?php echo esc_html( $price_preview_number_description ); ?></p>
            </div>
            <div class="right">
                <p class="fancy-select-field">
	                <?php echo $output; ?>
                </p>
            </div>
        </div>
        <br>

        <?php
        if ( function_exists( 'inspiry_is_rvr_enabled' ) && inspiry_is_rvr_enabled() ) {
	        ?>
            <div class="main-options-wrap">
		        <?php
		        $dual_price_title       = esc_html__( 'Dual Property Price', ERE_TEXT_DOMAIN );
		        $dual_price_description = esc_html__( 'Enable/Disable dual price for properties.', ERE_TEXT_DOMAIN );
		        ?>
                <div class="left">
                    <h4 aria-label="<?php echo esc_attr( $dual_price_title ); ?>"><?php echo esc_html( $dual_price_title ); ?></h4>
                    <p class="description" aria-description="<?php echo esc_attr( $dual_price_description ); ?>"><?php echo esc_html( $dual_price_description ); ?></p>
                </div>
                <div class="right">
                    <p class="fancy-radio-option">
                        <span class="enable">
                            <input type="radio" id="ere_property_dual_price_enable" name="ere_property_dual_price_status" value="enable" <?php checked( $ere_property_dual_price_status, 'enable' ) ?>>
                            <label class="button-primary" for="ere_property_dual_price_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                        <span class="disable">
                            <input type="radio" id="ere_property_dual_price_disable" name="ere_property_dual_price_status" value="disable" <?php checked( $ere_property_dual_price_status, 'disable' ) ?>>
                            <label class="button-primary" for="ere_property_dual_price_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                    </p>
                </div>
            </div>
            <hr>
	        <?php
        }
        ?>

        <div class="submit">
			<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
            <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
            <p><?php esc_html_e( 'Note: If you have enabled RealHomes Currency Switcher then default format of selected base currency will override above settings.', ERE_TEXT_DOMAIN ); ?></p>
        </div>
    </form>
</div>