<?php
/**
 * @package easy_real_estate
 * @subpackage shortcodes
 * This file contains code related to properties shortcode integration with visual composer.
 */


/**
 * Integrates properties shortcode with Visual Composer
 */
if ( ! function_exists( 'ere_shortcodes_integration' ) ) {

	function ere_shortcodes_integration() {
		/*
		 * Locations
		 */
		$locations_nam_slug_array = array();
		$all_locations       = ERE_Data::get_hierarchical_locations();
		if ( ! empty( $all_locations ) ) {
			foreach ( $all_locations as $top_level_locations ) {
				$locations_nam_slug_array[ $top_level_locations['name'] ] = $top_level_locations['slug'];
			}
		}

		/*
		 * Statuses
		 */
		$property_statuses_name_slug_array = array();
		$all_statuses       = ERE_Data::get_hierarchical_property_statuses();
		if ( ! empty( $all_statuses ) ) {
			foreach ( $all_statuses as $property_status ) {
				$property_statuses_name_slug_array[ $property_status['name'] ] = $property_status['slug'];
			}
		}

		/*
		 * Types
		 */
		$property_types_name_slug_array = array();
		$all_types       = ERE_Data::get_hierarchical_property_types();
		if ( ! empty( $all_types ) ) {
			foreach ( $all_types as $top_level_type ) {
				$property_types_name_slug_array[ $top_level_type['name'] ] = $top_level_type['slug'];
			}
		}

		/*
		 * Features
		 */
		$features_name_slug_array = array();
		$all_features             = ERE_Data::get_hierarchical_property_features();
		if ( ! empty( $all_features ) ) {
			foreach ( $all_features as $feature ) {
				$features_name_slug_array[ $feature['name'] ] = $feature['slug'];
			}
		}

		/*
		 * Agents
		 */
		$agents_array = array();
		$agents_posts = get_posts(
			array(
				'post_type'        => 'agent',
				'posts_per_page'   => - 1,
				'suppress_filters' => 0,
			)
		);
		if ( count( $agents_posts ) > 0 ) {
			foreach ( $agents_posts as $agent_post ) {
				$agents_array[ $agent_post->post_title ] = $agent_post->ID;
			}
		}

		vc_map( array(
			'name'        => esc_html__( 'Properties', ERE_TEXT_DOMAIN ),
			'description' => esc_html__( 'List of Properties', ERE_TEXT_DOMAIN ),
			'base'        => 'properties',
			'category'    => esc_html__( 'RealHomes Theme', ERE_TEXT_DOMAIN ),
			'params'      => array(
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Layout', ERE_TEXT_DOMAIN ),
					'param_name'  => 'layout',
					'value'       => array(
						'Grid' => 'grid',
						'List' => 'list',
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Number of Properties', ERE_TEXT_DOMAIN ),
					'param_name'  => 'count',
					'value'       => array(
						esc_html__( 'All', ERE_TEXT_DOMAIN ) => - 1,
						'1'                      => 1,
						'2'                      => 2,
						'3'                      => 3,
						'4'                      => 4,
						'5'                      => 5,
						'6'                      => 6,
						'7'                      => 7,
						'8'                      => 8,
						'9'                      => 9,
						'10'                     => 10,
						'11'                     => 11,
						'12'                     => 12,
						'13'                     => 13,
						'14'                     => 14,
						'15'                     => 15,
						'16'                     => 16,
					),
					'admin_label' => true,
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order By', ERE_TEXT_DOMAIN ),
					'param_name' => 'orderby',
					'value'      => array(
						esc_html__( 'Date', ERE_TEXT_DOMAIN )  => 'date',
						esc_html__( 'Price', ERE_TEXT_DOMAIN ) => 'price',
					),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order', ERE_TEXT_DOMAIN ),
					'param_name' => 'order',
					'value'      => array(
						esc_html__( 'Descending', ERE_TEXT_DOMAIN ) => 'DESC',
						esc_html__( 'Ascending', ERE_TEXT_DOMAIN )  => 'ASC',
					),
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Agent', ERE_TEXT_DOMAIN ),
					'param_name'  => 'agent',
					'value'       => $agents_array,
					'admin_label' => true,
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Locations', ERE_TEXT_DOMAIN ),
					'param_name'  => 'locations',
					'value'       => $locations_nam_slug_array,
					'admin_label' => true,
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Statuses', ERE_TEXT_DOMAIN ),
					'param_name'  => 'statuses',
					'value'       => $property_statuses_name_slug_array,
					'admin_label' => true,
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Types', ERE_TEXT_DOMAIN ),
					'param_name'  => 'types',
					'value'       => $property_types_name_slug_array,
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Minimum Bedrooms', ERE_TEXT_DOMAIN ),
					'param_name'  => 'min_beds',
					'value'       => array(
						ere_any_text() => null,
						'1'                => 1,
						'2'                => 2,
						'3'                => 3,
						'4'                => 4,
						'5'                => 5,
						'6'                => 6,
						'7'                => 7,
						'8'                => 8,
						'9'                => 9,
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Maximum Bedrooms', ERE_TEXT_DOMAIN ),
					'param_name'  => 'max_beds',
					'value'       => array(
						ere_any_text() => null,
						'1'                => 1,
						'2'                => 2,
						'3'                => 3,
						'4'                => 4,
						'5'                => 5,
						'6'                => 6,
						'7'                => 7,
						'8'                => 8,
						'9'                => 9,
						'10'               => 10,
						'11'               => 11,
						'12'               => 12,
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Minimum Bathrooms', ERE_TEXT_DOMAIN ),
					'param_name'  => 'min_baths',
					'value'       => array(
						ere_any_text() => null,
						'1'                => 1,
						'2'                => 2,
						'3'                => 3,
						'4'                => 4,
						'5'                => 5,
						'6'                => 6,
						'7'                => 7,
						'8'                => 8,
						'9'                => 9,
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Maximum Bathrooms', ERE_TEXT_DOMAIN ),
					'param_name'  => 'max_baths',
					'value'       => array(
						ere_any_text() => null,
						'1'                => 1,
						'2'                => 2,
						'3'                => 3,
						'4'                => 4,
						'5'                => 5,
						'6'                => 6,
						'7'                => 7,
						'8'                => 8,
						'9'                => 9,
						'10'               => 10,
						'11'               => 11,
						'12'               => 12,
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Minimum Price', ERE_TEXT_DOMAIN ),
					'description' => esc_html__( 'Only provide digits', ERE_TEXT_DOMAIN ),
					'param_name'  => 'min_price',
					'value'       => '',
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Maximum Price', ERE_TEXT_DOMAIN ),
					'description' => esc_html__( 'Only provide digits', ERE_TEXT_DOMAIN ),
					'param_name'  => 'max_price',
					'value'       => '',
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Minimum Area', ERE_TEXT_DOMAIN ),
					'description' => esc_html__( 'Only provide digits', ERE_TEXT_DOMAIN ),
					'param_name'  => 'min_area',
					'value'       => '',
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Maximum Area', ERE_TEXT_DOMAIN ),
					'description' => esc_html__( 'Only provide digits', ERE_TEXT_DOMAIN ),
					'param_name'  => 'max_area',
					'value'       => '',
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Display Only Featured Properties', ERE_TEXT_DOMAIN ),
					'param_name'  => 'featured',
					'value'       => array(
						esc_html__( 'No', ERE_TEXT_DOMAIN )  => 'no',
						esc_html__( 'Yes', ERE_TEXT_DOMAIN ) => 'yes',
					),
					'admin_label' => true,
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Features', ERE_TEXT_DOMAIN ),
					'param_name'  => 'features',
					'value'       => $features_name_slug_array,
					'admin_label' => true,
				),
			),
		) );
	}

	add_action( 'vc_before_init', 'ere_shortcodes_integration' );

}