/*!
 * bootstrap-tokenfield
 * https://github.com/sliptree/bootstrap-tokenfield
 * Copyright 2013-2014 Sliptree and other contributors; Licensed MIT
 */
!function(factory){"function"==typeof define&&define.amd?define(["jquery"],factory):"object"==typeof exports?module.exports=global.window&&global.window.$?factory(global.window.$):function(input){if(!input.$&&!input.fn)throw new Error("Tokenfield requires a window object with jQuery or a jQuery instance");return factory(input.$||input)}:factory(jQuery,window)}(function($,window){"use strict";var Tokenfield=function(element,options){var _self=this;this.$element=$(element),this.textDirection=this.$element.css("direction"),this.options=$.extend(!0,{},$.fn.tokenfield.defaults,{tokens:this.$element.val()},this.$element.data(),options),this._delimiters="string"==typeof this.options.delimiter?[this.options.delimiter]:this.options.delimiter,this._triggerKeys=$.map(this._delimiters,function(delimiter){return delimiter.charCodeAt(0)}),this._firstDelimiter=this._delimiters[0];var whitespace=$.inArray(" ",this._delimiters),dash=$.inArray("-",this._delimiters);whitespace>=0&&(this._delimiters[whitespace]="\\s"),dash>=0&&(delete this._delimiters[dash],this._delimiters.unshift("-"));var specialCharacters=["\\","$","[","{","^",".","|","?","*","+","(",")"];$.each(this._delimiters,function(index,character){$.inArray(character,specialCharacters)>=0&&(_self._delimiters[index]="\\"+character)});var elCSSWidth,elRules=window&&"function"==typeof window.getMatchedCSSRules?window.getMatchedCSSRules(element):null,elStyleWidth=element.style.width,elWidth=this.$element.width();elRules&&$.each(elRules,function(i,rule){rule.style.width&&(elCSSWidth=rule.style.width)});var hidingPosition="rtl"===$("body").css("direction")?"right":"left",originalStyles={position:this.$element.css("position")};originalStyles[hidingPosition]=this.$element.css(hidingPosition),this.$element.data("original-styles",originalStyles).data("original-tabindex",this.$element.prop("tabindex")).css("position","absolute").css(hidingPosition,"-10000px").prop("tabindex",-1),this.$wrapper=$('<div class="tokenfield form-control" />'),this.$element.hasClass("input-lg")&&this.$wrapper.addClass("input-lg"),this.$element.hasClass("input-sm")&&this.$wrapper.addClass("input-sm"),"rtl"===this.textDirection&&this.$wrapper.addClass("rtl");var id=this.$element.prop("id")||(new Date).getTime()+""+Math.floor(100*(1+Math.random()));this.$input=$('<input type="'+this.options.inputType+'" class="token-input" autocomplete="off" />').appendTo(this.$wrapper).prop("placeholder",this.$element.prop("placeholder")).prop("id",id+"-tokenfield").prop("tabindex",this.$element.data("original-tabindex"));var $label=$('label[for="'+this.$element.prop("id")+'"]');if($label.length&&$label.prop("for",this.$input.prop("id")),this.$copyHelper=$('<input type="text" />').css("position","absolute").css(hidingPosition,"-10000px").prop("tabindex",-1).prependTo(this.$wrapper),elStyleWidth?this.$wrapper.css("width",elStyleWidth):elCSSWidth?this.$wrapper.css("width",elCSSWidth):this.$element.parents(".form-inline").length&&this.$wrapper.width(elWidth),(this.$element.prop("disabled")||this.$element.parents("fieldset[disabled]").length)&&this.disable(),this.$element.prop("readonly")&&this.readonly(),this.$mirror=$('<span style="position:absolute; top:-999px; left:0; white-space:pre;"/>'),this.$input.css("min-width",this.options.minWidth+"px"),$.each(["fontFamily","fontSize","fontWeight","fontStyle","letterSpacing","textTransform","wordSpacing","textIndent"],function(i,val){_self.$mirror[0].style[val]=_self.$input.css(val)}),this.$mirror.appendTo("body"),this.$wrapper.insertBefore(this.$element),this.$element.prependTo(this.$wrapper),this.update(),this.setTokens(this.options.tokens,!1,!this.$element.val()&&this.options.tokens),this.listen(),!$.isEmptyObject(this.options.autocomplete)){var side="rtl"===this.textDirection?"right":"left",autocompleteOptions=$.extend({minLength:this.options.showAutocompleteOnFocus?0:null,position:{my:side+" top",at:side+" bottom",of:this.$wrapper}},this.options.autocomplete);this.$input.autocomplete(autocompleteOptions)}if(!$.isEmptyObject(this.options.typeahead)){var typeaheadOptions=this.options.typeahead,defaults={minLength:this.options.showAutocompleteOnFocus?0:null},args=$.isArray(typeaheadOptions)?typeaheadOptions:[typeaheadOptions,typeaheadOptions];args[0]=$.extend({},defaults,args[0]),this.$input.typeahead.apply(this.$input,args),this.typeahead=!0}};Tokenfield.prototype={constructor:Tokenfield,createToken:function(attrs,triggerChange){var _self=this;if(void 0===triggerChange&&(triggerChange=!0),(attrs="string"==typeof attrs?{value:attrs,label:attrs}:$.extend({},attrs)).value=$.trim(attrs.value.toString()),attrs.label=attrs.label&&attrs.label.length?$.trim(attrs.label):attrs.value,attrs.value.length&&attrs.label.length&&!(attrs.label.length<=this.options.minLength)&&!(this.options.limit&&this.getTokens().length>=this.options.limit)){var createEvent=$.Event("tokenfield:createtoken",{attrs:attrs});if(this.$element.trigger(createEvent),createEvent.attrs&&!createEvent.isDefaultPrevented()){var $token=$('<div class="token" />').append('<span class="token-label" />').append('<a href="#" class="close" tabindex="-1">X</a>').data("attrs",attrs);this.$input.hasClass("tt-input")?this.$input.parent().before($token):this.$input.before($token),this.$input.css("width",this.options.minWidth+"px");var $tokenLabel=$token.find(".token-label"),$closeButton=$token.find(".close");this.maxTokenWidth||(this.maxTokenWidth=this.$wrapper.width()-$closeButton.outerWidth()-parseInt($closeButton.css("margin-left"),10)-parseInt($closeButton.css("margin-right"),10)-parseInt($token.css("border-left-width"),10)-parseInt($token.css("border-right-width"),10)-parseInt($token.css("padding-left"),10)-parseInt($token.css("padding-right"),10),parseInt($tokenLabel.css("border-left-width"),10),parseInt($tokenLabel.css("border-right-width"),10),parseInt($tokenLabel.css("padding-left"),10),parseInt($tokenLabel.css("padding-right"),10),parseInt($tokenLabel.css("margin-left"),10),parseInt($tokenLabel.css("margin-right"),10)),$tokenLabel.css("max-width",this.maxTokenWidth),this.options.html?$tokenLabel.html(attrs.label):$tokenLabel.text(attrs.label),$token.on("mousedown",function(e){if(_self._disabled||_self._readonly)return!1;_self.preventDeactivation=!0}).on("click",function(e){return!_self._disabled&&!_self._readonly&&(_self.preventDeactivation=!1,e.ctrlKey||e.metaKey?(e.preventDefault(),_self.toggle($token)):void _self.activate($token,e.shiftKey,e.shiftKey))}).on("dblclick",function(e){if(_self._disabled||_self._readonly||!_self.options.allowEditing)return!1;_self.edit($token)}),$closeButton.on("click",$.proxy(this.remove,this)),this.$element.trigger($.Event("tokenfield:createdtoken",{attrs:attrs,relatedTarget:$token.get(0)})),triggerChange&&this.$element.val(this.getTokensList()).trigger($.Event("change",{initiator:"tokenfield"}));_self=this;return setTimeout(function(){_self.update()},0),this.$element.get(0)}}},setTokens:function(tokens,add,triggerChange){if(add||this.$wrapper.find(".token").remove(),tokens){void 0===triggerChange&&(triggerChange=!0),"string"==typeof tokens&&(tokens=this._delimiters.length?tokens.split(new RegExp("["+this._delimiters.join("")+"]")):[tokens]);var _self=this;return $.each(tokens,function(i,attrs){_self.createToken(attrs,triggerChange)}),this.$element.get(0)}},getTokenData:function($token){var data=$token.map(function(){return $(this).data("attrs")}).get();return 1==data.length&&(data=data[0]),data},getTokens:function(active){var self=this,tokens=[],activeClass=active?".active":"";return this.$wrapper.find(".token"+activeClass).each(function(){tokens.push(self.getTokenData($(this)))}),tokens},getTokensList:function(delimiter,beautify,active){var separator=(delimiter=delimiter||this._firstDelimiter)+((beautify=null!=beautify?beautify:this.options.beautify)&&" "!==delimiter?" ":"");return $.map(this.getTokens(active),function(token){return token.value}).join(separator)},getInput:function(){return this.$input.val()},setInput:function(val){this.$input.hasClass("tt-input")?this.$input.typeahead("val",val):this.$input.val(val)},listen:function(){var _self=this;this.$element.on("change",$.proxy(this.change,this)),this.$wrapper.on("mousedown",$.proxy(this.focusInput,this)),this.$input.on("focus",$.proxy(this.focus,this)).on("blur",$.proxy(this.blur,this)).on("paste",$.proxy(this.paste,this)).on("keydown",$.proxy(this.keydown,this)).on("keypress",$.proxy(this.keypress,this)).on("keyup",$.proxy(this.keyup,this)),this.$copyHelper.on("focus",$.proxy(this.focus,this)).on("blur",$.proxy(this.blur,this)).on("keydown",$.proxy(this.keydown,this)).on("keyup",$.proxy(this.keyup,this)),this.$input.on("keypress",$.proxy(this.update,this)).on("keyup",$.proxy(this.update,this)),this.$input.on("autocompletecreate",function(){var $_menuElement=$(this).data("ui-autocomplete").menu.element,minWidth=_self.$wrapper.outerWidth()-parseInt($_menuElement.css("border-left-width"),10)-parseInt($_menuElement.css("border-right-width"),10);$_menuElement.css("min-width",minWidth+"px")}).on("autocompleteselect",function(e,ui){return _self.createToken(ui.item)&&(_self.$input.val(""),_self.$input.data("edit")&&_self.unedit(!0)),!1}).on("typeahead:selected typeahead:autocompleted",function(e,datum,dataset){_self.createToken(datum)&&(_self.$input.typeahead("val",""),_self.$input.data("edit")&&_self.unedit(!0))}),$(window).on("resize",$.proxy(this.update,this))},keydown:function(e){if(this.focused){var _self=this;switch(e.keyCode){case 8:if(!this.$input.is(document.activeElement))break;this.lastInputValue=this.$input.val();break;case 37:leftRight("rtl"===this.textDirection?"next":"prev");break;case 38:upDown("prev");break;case 39:leftRight("rtl"===this.textDirection?"prev":"next");break;case 40:upDown("next");break;case 65:if(this.$input.val().length>0||!e.ctrlKey&&!e.metaKey)break;this.activateAll(),e.preventDefault();break;case 9:case 13:if(this.$input.data("ui-autocomplete")&&this.$input.data("ui-autocomplete").menu.element.find("li:has(a.ui-state-focus), li.ui-state-focus").length)break;if(this.$input.hasClass("tt-input")&&this.$wrapper.find(".tt-cursor").length)break;if(this.$input.hasClass("tt-input")&&this.$wrapper.find(".tt-hint").val()&&this.$wrapper.find(".tt-hint").val().length)break;if(this.$input.is(document.activeElement)&&this.$input.val().length||this.$input.data("edit"))return this.createTokensFromInput(e,this.$input.data("edit"));if(13===e.keyCode){if(!this.$copyHelper.is(document.activeElement)||1!==this.$wrapper.find(".token.active").length)break;if(!_self.options.allowEditing)break;this.edit(this.$wrapper.find(".token.active"))}}this.lastKeyDown=e.keyCode}function leftRight(direction){if(_self.$input.is(document.activeElement)){if(_self.$input.val().length>0)return;direction+="All";var $token=_self.$input.hasClass("tt-input")?_self.$input.parent()[direction](".token:first"):_self.$input[direction](".token:first");if(!$token.length)return;_self.preventInputFocus=!0,_self.preventDeactivation=!0,_self.activate($token),e.preventDefault()}else _self[direction](e.shiftKey),e.preventDefault()}function upDown(direction){if(e.shiftKey){if(_self.$input.is(document.activeElement)){if(_self.$input.val().length>0)return;var $token=_self.$input.hasClass("tt-input")?_self.$input.parent()[direction+"All"](".token:first"):_self.$input[direction+"All"](".token:first");if(!$token.length)return;_self.activate($token)}var opposite="prev"===direction?"next":"prev",position="prev"===direction?"first":"last";_self.$firstActiveToken[opposite+"All"](".token").each(function(){_self.deactivate($(this))}),_self.activate(_self.$wrapper.find(".token:"+position),!0,!0),e.preventDefault()}}},keypress:function(e){if(-1!==$.inArray(e.which,this._triggerKeys)&&this.$input.is(document.activeElement))return this.$input.val()&&this.createTokensFromInput(e),!1},keyup:function(e){if(this.preventInputFocus=!1,this.focused){switch(e.keyCode){case 8:if(this.$input.is(document.activeElement)){if(this.$input.val().length||this.lastInputValue.length&&8===this.lastKeyDown)break;this.preventDeactivation=!0;var $prevToken=this.$input.hasClass("tt-input")?this.$input.parent().prevAll(".token:first"):this.$input.prevAll(".token:first");if(!$prevToken.length)break;this.activate($prevToken)}else this.remove(e);break;case 46:this.remove(e,"next")}this.lastKeyUp=e.keyCode}},focus:function(e){this.focused=!0,this.$wrapper.addClass("focus"),this.$input.is(document.activeElement)&&(this.$wrapper.find(".active").removeClass("active"),this.$firstActiveToken=null,this.options.showAutocompleteOnFocus&&this.search())},blur:function(e){this.focused=!1,this.$wrapper.removeClass("focus"),this.preventDeactivation||this.$element.is(document.activeElement)||(this.$wrapper.find(".active").removeClass("active"),this.$firstActiveToken=null),!this.preventCreateTokens&&(this.$input.data("edit")&&!this.$input.is(document.activeElement)||this.options.createTokensOnBlur)&&this.createTokensFromInput(e),this.preventDeactivation=!1,this.preventCreateTokens=!1},paste:function(e){var _self=this;_self.options.allowPasting&&setTimeout(function(){_self.createTokensFromInput(e)},1)},change:function(e){"tokenfield"!==e.initiator&&this.setTokens(this.$element.val())},createTokensFromInput:function(e,focus){if(!(this.$input.val().length<this.options.minLength)){var tokensBefore=this.getTokensList();return this.setTokens(this.$input.val(),!0),tokensBefore==this.getTokensList()&&this.$input.val().length?!1:(this.setInput(""),this.$input.data("edit")&&this.unedit(focus),!1)}},next:function(add){if(add){var $firstActiveToken=this.$wrapper.find(".active:first");if(!(!$firstActiveToken||!this.$firstActiveToken)&&$firstActiveToken.index()<this.$firstActiveToken.index())return this.deactivate($firstActiveToken)}var $nextToken=this.$wrapper.find(".active:last").nextAll(".token:first");$nextToken.length?this.activate($nextToken,add):this.$input.focus()},prev:function(add){if(add){var $lastActiveToken=this.$wrapper.find(".active:last");if(!(!$lastActiveToken||!this.$firstActiveToken)&&$lastActiveToken.index()>this.$firstActiveToken.index())return this.deactivate($lastActiveToken)}var $prevToken=this.$wrapper.find(".active:first").prevAll(".token:first");$prevToken.length||($prevToken=this.$wrapper.find(".token:first")),$prevToken.length||add?this.activate($prevToken,add):this.$input.focus()},activate:function($token,add,multi,remember){if($token){if(void 0===remember)remember=!0;if(multi)add=!0;if(this.$copyHelper.focus(),add||(this.$wrapper.find(".active").removeClass("active"),remember?this.$firstActiveToken=$token:delete this.$firstActiveToken),multi&&this.$firstActiveToken){var i=this.$firstActiveToken.index()-2,a=$token.index()-2,_self=this;this.$wrapper.find(".token").slice(Math.min(i,a)+1,Math.max(i,a)).each(function(){_self.activate($(this),!0)})}$token.addClass("active"),this.$copyHelper.val(this.getTokensList(null,null,!0)).select()}},activateAll:function(){var _self=this;this.$wrapper.find(".token").each(function(i){_self.activate($(this),0!==i,!1,!1)})},deactivate:function($token){$token&&($token.removeClass("active"),this.$copyHelper.val(this.getTokensList(null,null,!0)).select())},toggle:function($token){$token&&($token.toggleClass("active"),this.$copyHelper.val(this.getTokensList(null,null,!0)).select())},edit:function($token){if($token){var attrs=$token.data("attrs"),options={attrs:attrs,relatedTarget:$token.get(0)},editEvent=$.Event("tokenfield:edittoken",options);if(this.$element.trigger(editEvent),!editEvent.isDefaultPrevented()){$token.find(".token-label").text(attrs.value);var tokenWidth=$token.outerWidth(),$_input=this.$input.hasClass("tt-input")?this.$input.parent():this.$input;$token.replaceWith($_input),this.preventCreateTokens=!0,this.$input.val(attrs.value).select().data("edit",!0).width(tokenWidth),this.update(),this.$element.trigger($.Event("tokenfield:editedtoken",options))}}},unedit:function(focus){if((this.$input.hasClass("tt-input")?this.$input.parent():this.$input).appendTo(this.$wrapper),this.$input.data("edit",!1),this.$mirror.text(""),this.update(),focus){var _self=this;setTimeout(function(){_self.$input.focus()},1)}},remove:function(e,direction){if(!(this.$input.is(document.activeElement)||this._disabled||this._readonly)){var $token="click"===e.type?$(e.target).closest(".token"):this.$wrapper.find(".token.active");if("click"!==e.type){if(!direction)direction="prev";if(this[direction](),"prev"===direction)var firstToken=0===$token.first().prevAll(".token:first").length}var options={attrs:this.getTokenData($token),relatedTarget:$token.get(0)},removeEvent=$.Event("tokenfield:removetoken",options);if(this.$element.trigger(removeEvent),!removeEvent.isDefaultPrevented()){var removedEvent=$.Event("tokenfield:removedtoken",options),changeEvent=$.Event("change",{initiator:"tokenfield"});$token.remove(),this.$element.val(this.getTokensList()).trigger(removedEvent).trigger(changeEvent),this.$wrapper.find(".token").length&&"click"!==e.type&&!firstToken||this.$input.focus(),this.$input.css("width",this.options.minWidth+"px"),this.update(),e.preventDefault(),e.stopPropagation()}}},update:function(e){var value=this.$input.val(),inputPadding=parseInt(this.$input.css("padding-left"),10)+parseInt(this.$input.css("padding-right"),10);if(this.$input.data("edit")){if(value||(value=this.$input.prop("placeholder")),value===this.$mirror.text())return;this.$mirror.text(value);var mirrorWidth=this.$mirror.width()+10;if(mirrorWidth>this.$wrapper.width())return this.$input.width(this.$wrapper.width());this.$input.width(mirrorWidth)}else{this.$input.width(this.options.minWidth);var w="rtl"===this.textDirection?this.$input.offset().left+this.$input.outerWidth()-this.$wrapper.offset().left-parseInt(this.$wrapper.css("padding-left"),10)-inputPadding-1:this.$wrapper.offset().left+this.$wrapper.width()+parseInt(this.$wrapper.css("padding-left"),10)-this.$input.offset().left-inputPadding;isNaN(w)?this.$input.width("100%"):this.$input.width(w)}},focusInput:function(e){if(!($(e.target).closest(".token").length||$(e.target).closest(".token-input").length||$(e.target).closest(".tt-dropdown-menu").length)){var _self=this;setTimeout(function(){_self.$input.focus()},0)}},search:function(){this.$input.data("ui-autocomplete")&&this.$input.autocomplete("search")},disable:function(){this.setProperty("disabled",!0)},enable:function(){this.setProperty("disabled",!1)},readonly:function(){this.setProperty("readonly",!0)},writeable:function(){this.setProperty("readonly",!1)},setProperty:function(property,value){this["_"+property]=value,this.$input.prop(property,value),this.$element.prop(property,value),this.$wrapper[value?"addClass":"removeClass"](property)},destroy:function(){this.$element.val(this.getTokensList()),this.$element.css(this.$element.data("original-styles")),this.$element.prop("tabindex",this.$element.data("original-tabindex"));var $label=$('label[for="'+this.$input.prop("id")+'"]');return $label.length&&$label.prop("for",this.$element.prop("id")),this.$element.insertBefore(this.$wrapper),this.$element.removeData("original-styles").removeData("original-tabindex").removeData("bs.tokenfield"),this.$wrapper.remove(),this.$mirror.remove(),this.$element}};var old=$.fn.tokenfield;return $.fn.tokenfield=function(option,param){var value,args=[];Array.prototype.push.apply(args,arguments);var elements=this.each(function(){var $this=$(this),data=$this.data("bs.tokenfield"),options="object"==typeof option&&option;"string"==typeof option&&data&&data[option]?(args.shift(),value=data[option].apply(data,args)):data||"string"==typeof option||param||($this.data("bs.tokenfield",data=new Tokenfield(this,options)),$this.trigger("tokenfield:initialize"))});return void 0!==value?value:elements},$.fn.tokenfield.defaults={minWidth:60,minLength:0,html:!0,allowEditing:!0,allowPasting:!0,limit:0,autocomplete:{},typeahead:{},showAutocompleteOnFocus:!1,createTokensOnBlur:!1,delimiter:",",beautify:!0,inputType:"text"},$.fn.tokenfield.Constructor=Tokenfield,$.fn.tokenfield.noConflict=function(){return $.fn.tokenfield=old,this},Tokenfield});
