/*!
  * vue-router v3.5.2
  * (c) 2021 Evan You
  * @license MIT
  */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global="undefined"!=typeof globalThis?globalThis:global||self).VueRouter=factory()}(this,function(){"use strict";function assert(condition,message){if(!condition)throw new Error("[vue-router] "+message)}function warn(condition,message){condition||"undefined"!=typeof console&&console.warn("[vue-router] "+message)}function extend(a,b){for(var key in b)a[key]=b[key];return a}var encodeReserveRE=/[!'()*]/g,encodeReserveReplacer=function(c){return"%"+c.charCodeAt(0).toString(16)},commaRE=/%2C/g,encode=function(str){return encodeURIComponent(str).replace(encodeReserveRE,encodeReserveReplacer).replace(commaRE,",")};function decode(str){try{return decodeURIComponent(str)}catch(err){warn(!1,'Error decoding "'+str+'". Leaving it intact.')}return str}var castQueryParamValue=function(value){return null==value||"object"==typeof value?value:String(value)};function parseQuery(query){var res={};return(query=query.trim().replace(/^(\?|#|&)/,""))?(query.split("&").forEach(function(param){var parts=param.replace(/\+/g," ").split("="),key=decode(parts.shift()),val=parts.length>0?decode(parts.join("=")):null;void 0===res[key]?res[key]=val:Array.isArray(res[key])?res[key].push(val):res[key]=[res[key],val]}),res):res}function stringifyQuery(obj){var res=obj?Object.keys(obj).map(function(key){var val=obj[key];if(void 0===val)return"";if(null===val)return encode(key);if(Array.isArray(val)){var result=[];return val.forEach(function(val2){void 0!==val2&&(null===val2?result.push(encode(key)):result.push(encode(key)+"="+encode(val2)))}),result.join("&")}return encode(key)+"="+encode(val)}).filter(function(x){return x.length>0}).join("&"):null;return res?"?"+res:""}var trailingSlashRE=/\/?$/;function createRoute(record,location,redirectedFrom,router){var stringifyQuery=router&&router.options.stringifyQuery,query=location.query||{};try{query=clone(query)}catch(e){}var route={name:location.name||record&&record.name,meta:record&&record.meta||{},path:location.path||"/",hash:location.hash||"",query:query,params:location.params||{},fullPath:getFullPath(location,stringifyQuery),matched:record?formatMatch(record):[]};return redirectedFrom&&(route.redirectedFrom=getFullPath(redirectedFrom,stringifyQuery)),Object.freeze(route)}function clone(value){if(Array.isArray(value))return value.map(clone);if(value&&"object"==typeof value){var res={};for(var key in value)res[key]=clone(value[key]);return res}return value}var START=createRoute(null,{path:"/"});function formatMatch(record){for(var res=[];record;)res.unshift(record),record=record.parent;return res}function getFullPath(ref,_stringifyQuery){var path=ref.path,query=ref.query;void 0===query&&(query={});var hash=ref.hash;return void 0===hash&&(hash=""),(path||"/")+(_stringifyQuery||stringifyQuery)(query)+hash}function isSameRoute(a,b,onlyPath){return b===START?a===b:!!b&&(a.path&&b.path?a.path.replace(trailingSlashRE,"")===b.path.replace(trailingSlashRE,"")&&(onlyPath||a.hash===b.hash&&isObjectEqual(a.query,b.query)):!(!a.name||!b.name)&&(a.name===b.name&&(onlyPath||a.hash===b.hash&&isObjectEqual(a.query,b.query)&&isObjectEqual(a.params,b.params))))}function isObjectEqual(a,b){if(void 0===a&&(a={}),void 0===b&&(b={}),!a||!b)return a===b;var aKeys=Object.keys(a).sort(),bKeys=Object.keys(b).sort();return aKeys.length===bKeys.length&&aKeys.every(function(key,i){var aVal=a[key];if(bKeys[i]!==key)return!1;var bVal=b[key];return null==aVal||null==bVal?aVal===bVal:"object"==typeof aVal&&"object"==typeof bVal?isObjectEqual(aVal,bVal):String(aVal)===String(bVal)})}function handleRouteEntered(route){for(var i=0;i<route.matched.length;i++){var record=route.matched[i];for(var name in record.instances){var instance=record.instances[name],cbs=record.enteredCbs[name];if(instance&&cbs){delete record.enteredCbs[name];for(var i$1=0;i$1<cbs.length;i$1++)instance._isBeingDestroyed||cbs[i$1](instance)}}}}var View={name:"RouterView",functional:!0,props:{name:{type:String,default:"default"}},render:function render(_,ref){var props=ref.props,children=ref.children,parent=ref.parent,data=ref.data;data.routerView=!0;for(var h=parent.$createElement,name=props.name,route=parent.$route,cache=parent._routerViewCache||(parent._routerViewCache={}),depth=0,inactive=!1;parent&&parent._routerRoot!==parent;){var vnodeData=parent.$vnode?parent.$vnode.data:{};vnodeData.routerView&&depth++,vnodeData.keepAlive&&parent._directInactive&&parent._inactive&&(inactive=!0),parent=parent.$parent}if(data.routerViewDepth=depth,inactive){var cachedData=cache[name],cachedComponent=cachedData&&cachedData.component;return cachedComponent?(cachedData.configProps&&fillPropsinData(cachedComponent,data,cachedData.route,cachedData.configProps),h(cachedComponent,data,children)):h()}var matched=route.matched[depth],component=matched&&matched.components[name];if(!matched||!component)return cache[name]=null,h();cache[name]={component:component},data.registerRouteInstance=function(vm,val){var current=matched.instances[name];(val&&current!==vm||!val&&current===vm)&&(matched.instances[name]=val)},(data.hook||(data.hook={})).prepatch=function(_,vnode){matched.instances[name]=vnode.componentInstance},data.hook.init=function(vnode){vnode.data.keepAlive&&vnode.componentInstance&&vnode.componentInstance!==matched.instances[name]&&(matched.instances[name]=vnode.componentInstance),handleRouteEntered(route)};var configProps=matched.props&&matched.props[name];return configProps&&(extend(cache[name],{route:route,configProps:configProps}),fillPropsinData(component,data,route,configProps)),h(component,data,children)}};function fillPropsinData(component,data,route,configProps){var propsToPass=data.props=function resolveProps(route,config){switch(typeof config){case"undefined":return;case"object":return config;case"function":return config(route);case"boolean":return config?route.params:void 0;default:warn(!1,'props in "'+route.path+'" is a '+typeof config+", expecting an object, function or boolean.")}}(route,configProps);if(propsToPass){propsToPass=data.props=extend({},propsToPass);var attrs=data.attrs=data.attrs||{};for(var key in propsToPass)component.props&&key in component.props||(attrs[key]=propsToPass[key],delete propsToPass[key])}}function resolvePath(relative,base,append){var firstChar=relative.charAt(0);if("/"===firstChar)return relative;if("?"===firstChar||"#"===firstChar)return base+relative;var stack=base.split("/");append&&stack[stack.length-1]||stack.pop();for(var segments=relative.replace(/^\//,"").split("/"),i=0;i<segments.length;i++){var segment=segments[i];".."===segment?stack.pop():"."!==segment&&stack.push(segment)}return""!==stack[0]&&stack.unshift(""),stack.join("/")}function cleanPath(path){return path.replace(/\/\//g,"/")}var isarray=Array.isArray||function(arr){return"[object Array]"==Object.prototype.toString.call(arr)},pathToRegexp_1=pathToRegexp,parse_1=parse,compile_1=function compile(str,options){return tokensToFunction(parse(str,options),options)},tokensToFunction_1=tokensToFunction,tokensToRegExp_1=tokensToRegExp,PATH_REGEXP=new RegExp(["(\\\\.)","([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?|(\\*))"].join("|"),"g");function parse(str,options){for(var res,tokens=[],key=0,index=0,path="",defaultDelimiter=options&&options.delimiter||"/";null!=(res=PATH_REGEXP.exec(str));){var m=res[0],escaped=res[1],offset=res.index;if(path+=str.slice(index,offset),index=offset+m.length,escaped)path+=escaped[1];else{var next=str[index],prefix=res[2],name=res[3],capture=res[4],group=res[5],modifier=res[6],asterisk=res[7];path&&(tokens.push(path),path="");var partial=null!=prefix&&null!=next&&next!==prefix,repeat="+"===modifier||"*"===modifier,optional="?"===modifier||"*"===modifier,delimiter=res[2]||defaultDelimiter,pattern=capture||group;tokens.push({name:name||key++,prefix:prefix||"",delimiter:delimiter,optional:optional,repeat:repeat,partial:partial,asterisk:!!asterisk,pattern:pattern?escapeGroup(pattern):asterisk?".*":"[^"+escapeString(delimiter)+"]+?"})}}return index<str.length&&(path+=str.substr(index)),path&&tokens.push(path),tokens}function encodeURIComponentPretty(str){return encodeURI(str).replace(/[\/?#]/g,function(c){return"%"+c.charCodeAt(0).toString(16).toUpperCase()})}function encodeAsterisk(str){return encodeURI(str).replace(/[?#]/g,function(c){return"%"+c.charCodeAt(0).toString(16).toUpperCase()})}function tokensToFunction(tokens,options){for(var matches=new Array(tokens.length),i=0;i<tokens.length;i++)"object"==typeof tokens[i]&&(matches[i]=new RegExp("^(?:"+tokens[i].pattern+")$",flags(options)));return function(obj,opts){for(var path="",data=obj||{},encode=(opts||{}).pretty?encodeURIComponentPretty:encodeURIComponent,i=0;i<tokens.length;i++){var token=tokens[i];if("string"!=typeof token){var segment,value=data[token.name];if(null==value){if(token.optional){token.partial&&(path+=token.prefix);continue}throw new TypeError('Expected "'+token.name+'" to be defined')}if(isarray(value)){if(!token.repeat)throw new TypeError('Expected "'+token.name+'" to not repeat, but received `'+JSON.stringify(value)+"`");if(0===value.length){if(token.optional)continue;throw new TypeError('Expected "'+token.name+'" to not be empty')}for(var j=0;j<value.length;j++){if(segment=encode(value[j]),!matches[i].test(segment))throw new TypeError('Expected all "'+token.name+'" to match "'+token.pattern+'", but received `'+JSON.stringify(segment)+"`");path+=(0===j?token.prefix:token.delimiter)+segment}}else{if(segment=token.asterisk?encodeAsterisk(value):encode(value),!matches[i].test(segment))throw new TypeError('Expected "'+token.name+'" to match "'+token.pattern+'", but received "'+segment+'"');path+=token.prefix+segment}}else path+=token}return path}}function escapeString(str){return str.replace(/([.+*?=^!:${}()[\]|\/\\])/g,"\\$1")}function escapeGroup(group){return group.replace(/([=!:$\/()])/g,"\\$1")}function attachKeys(re,keys){return re.keys=keys,re}function flags(options){return options&&options.sensitive?"":"i"}function tokensToRegExp(tokens,keys,options){isarray(keys)||(options=keys||options,keys=[]);for(var strict=(options=options||{}).strict,end=!1!==options.end,route="",i=0;i<tokens.length;i++){var token=tokens[i];if("string"==typeof token)route+=escapeString(token);else{var prefix=escapeString(token.prefix),capture="(?:"+token.pattern+")";keys.push(token),token.repeat&&(capture+="(?:"+prefix+capture+")*"),route+=capture=token.optional?token.partial?prefix+"("+capture+")?":"(?:"+prefix+"("+capture+"))?":prefix+"("+capture+")"}}var delimiter=escapeString(options.delimiter||"/"),endsWithDelimiter=route.slice(-delimiter.length)===delimiter;return strict||(route=(endsWithDelimiter?route.slice(0,-delimiter.length):route)+"(?:"+delimiter+"(?=$))?"),route+=end?"$":strict&&endsWithDelimiter?"":"(?="+delimiter+"|$)",attachKeys(new RegExp("^"+route,flags(options)),keys)}function pathToRegexp(path,keys,options){return isarray(keys)||(options=keys||options,keys=[]),options=options||{},path instanceof RegExp?function regexpToRegexp(path,keys){var groups=path.source.match(/\((?!\?)/g);if(groups)for(var i=0;i<groups.length;i++)keys.push({name:i,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,asterisk:!1,pattern:null});return attachKeys(path,keys)}(path,keys):isarray(path)?function arrayToRegexp(path,keys,options){for(var parts=[],i=0;i<path.length;i++)parts.push(pathToRegexp(path[i],keys,options).source);return attachKeys(new RegExp("(?:"+parts.join("|")+")",flags(options)),keys)}(path,keys,options):function stringToRegexp(path,keys,options){return tokensToRegExp(parse(path,options),keys,options)}(path,keys,options)}pathToRegexp_1.parse=parse_1,pathToRegexp_1.compile=compile_1,pathToRegexp_1.tokensToFunction=tokensToFunction_1,pathToRegexp_1.tokensToRegExp=tokensToRegExp_1;var regexpCompileCache=Object.create(null);function fillParams(path,params,routeMsg){params=params||{};try{var filler=regexpCompileCache[path]||(regexpCompileCache[path]=pathToRegexp_1.compile(path));return"string"==typeof params.pathMatch&&(params[0]=params.pathMatch),filler(params,{pretty:!0})}catch(e){return warn("string"==typeof params.pathMatch,"missing param for "+routeMsg+": "+e.message),""}finally{delete params[0]}}function normalizeLocation(raw,current,append,router){var next="string"==typeof raw?{path:raw}:raw;if(next._normalized)return next;if(next.name){var params=(next=extend({},raw)).params;return params&&"object"==typeof params&&(next.params=extend({},params)),next}if(!next.path&&next.params&&current){(next=extend({},next))._normalized=!0;var params$1=extend(extend({},current.params),next.params);if(current.name)next.name=current.name,next.params=params$1;else if(current.matched.length){var rawPath=current.matched[current.matched.length-1].path;next.path=fillParams(rawPath,params$1,"path "+current.path)}else warn(!1,"relative params navigation requires a current route.");return next}var parsedPath=function parsePath(path){var hash="",query="",hashIndex=path.indexOf("#");hashIndex>=0&&(hash=path.slice(hashIndex),path=path.slice(0,hashIndex));var queryIndex=path.indexOf("?");return queryIndex>=0&&(query=path.slice(queryIndex+1),path=path.slice(0,queryIndex)),{path:path,query:query,hash:hash}}(next.path||""),basePath=current&&current.path||"/",path=parsedPath.path?resolvePath(parsedPath.path,basePath,append||next.append):basePath,query=function resolveQuery(query,extraQuery,_parseQuery){void 0===extraQuery&&(extraQuery={});var parsedQuery,parse=_parseQuery||parseQuery;try{parsedQuery=parse(query||"")}catch(e){warn(!1,e.message),parsedQuery={}}for(var key in extraQuery){var value=extraQuery[key];parsedQuery[key]=Array.isArray(value)?value.map(castQueryParamValue):castQueryParamValue(value)}return parsedQuery}(parsedPath.query,next.query,router&&router.options.parseQuery),hash=next.hash||parsedPath.hash;return hash&&"#"!==hash.charAt(0)&&(hash="#"+hash),{_normalized:!0,path:path,query:query,hash:hash}}var warnedCustomSlot,warnedTagProp,warnedEventProp,_Vue,noop=function(){},Link={name:"RouterLink",props:{to:{type:[String,Object],required:!0},tag:{type:String,default:"a"},custom:Boolean,exact:Boolean,exactPath:Boolean,append:Boolean,replace:Boolean,activeClass:String,exactActiveClass:String,ariaCurrentValue:{type:String,default:"page"},event:{type:[String,Array],default:"click"}},render:function render(h){var this$1=this,router=this.$router,current=this.$route,ref=router.resolve(this.to,current,this.append),location=ref.location,route=ref.route,href=ref.href,classes={},globalActiveClass=router.options.linkActiveClass,globalExactActiveClass=router.options.linkExactActiveClass,activeClassFallback=null==globalActiveClass?"router-link-active":globalActiveClass,exactActiveClassFallback=null==globalExactActiveClass?"router-link-exact-active":globalExactActiveClass,activeClass=null==this.activeClass?activeClassFallback:this.activeClass,exactActiveClass=null==this.exactActiveClass?exactActiveClassFallback:this.exactActiveClass,compareTarget=route.redirectedFrom?createRoute(null,normalizeLocation(route.redirectedFrom),null,router):route;classes[exactActiveClass]=isSameRoute(current,compareTarget,this.exactPath),classes[activeClass]=this.exact||this.exactPath?classes[exactActiveClass]:function isIncludedRoute(current,target){return 0===current.path.replace(trailingSlashRE,"/").indexOf(target.path.replace(trailingSlashRE,"/"))&&(!target.hash||current.hash===target.hash)&&function queryIncludes(current,target){for(var key in target)if(!(key in current))return!1;return!0}(current.query,target.query)}(current,compareTarget);var ariaCurrentValue=classes[exactActiveClass]?this.ariaCurrentValue:null,handler=function(e){guardEvent(e)&&(this$1.replace?router.replace(location,noop):router.push(location,noop))},on={click:guardEvent};Array.isArray(this.event)?this.event.forEach(function(e){on[e]=handler}):on[this.event]=handler;var data={class:classes},scopedSlot=!this.$scopedSlots.$hasNormal&&this.$scopedSlots.default&&this.$scopedSlots.default({href:href,route:route,navigate:handler,isActive:classes[activeClass],isExactActive:classes[exactActiveClass]});if(scopedSlot){if(this.custom||(!warnedCustomSlot&&warn(!1,'In Vue Router 4, the v-slot API will by default wrap its content with an <a> element. Use the custom prop to remove this warning:\n<router-link v-slot="{ navigate, href }" custom></router-link>\n'),warnedCustomSlot=!0),1===scopedSlot.length)return scopedSlot[0];if(scopedSlot.length>1||!scopedSlot.length)return warn(!1,'<router-link> with to="'+this.to+"\" is trying to use a scoped slot but it didn't provide exactly one child. Wrapping the content with a span element."),0===scopedSlot.length?h():h("span",{},scopedSlot)}if("tag"in this.$options.propsData&&!warnedTagProp&&(warn(!1,"<router-link>'s tag prop is deprecated and has been removed in Vue Router 4. Use the v-slot API to remove this warning: https://next.router.vuejs.org/guide/migration/#removal-of-event-and-tag-props-in-router-link."),warnedTagProp=!0),"event"in this.$options.propsData&&!warnedEventProp&&(warn(!1,"<router-link>'s event prop is deprecated and has been removed in Vue Router 4. Use the v-slot API to remove this warning: https://next.router.vuejs.org/guide/migration/#removal-of-event-and-tag-props-in-router-link."),warnedEventProp=!0),"a"===this.tag)data.on=on,data.attrs={href:href,"aria-current":ariaCurrentValue};else{var a=findAnchor(this.$slots.default);if(a){a.isStatic=!1;var aData=a.data=extend({},a.data);for(var event in aData.on=aData.on||{},aData.on){var handler$1=aData.on[event];event in on&&(aData.on[event]=Array.isArray(handler$1)?handler$1:[handler$1])}for(var event$1 in on)event$1 in aData.on?aData.on[event$1].push(on[event$1]):aData.on[event$1]=handler;var aAttrs=a.data.attrs=extend({},a.data.attrs);aAttrs.href=href,aAttrs["aria-current"]=ariaCurrentValue}else data.on=on}return h(this.tag,data,this.$slots.default)}};function guardEvent(e){if(!(e.metaKey||e.altKey||e.ctrlKey||e.shiftKey||e.defaultPrevented||void 0!==e.button&&0!==e.button)){if(e.currentTarget&&e.currentTarget.getAttribute){var target=e.currentTarget.getAttribute("target");if(/\b_blank\b/i.test(target))return}return e.preventDefault&&e.preventDefault(),!0}}function findAnchor(children){if(children)for(var child,i=0;i<children.length;i++){if("a"===(child=children[i]).tag)return child;if(child.children&&(child=findAnchor(child.children)))return child}}function install(Vue){if(!install.installed||_Vue!==Vue){install.installed=!0,_Vue=Vue;var isDef=function(v){return void 0!==v},registerInstance=function(vm,callVal){var i=vm.$options._parentVnode;isDef(i)&&isDef(i=i.data)&&isDef(i=i.registerRouteInstance)&&i(vm,callVal)};Vue.mixin({beforeCreate:function beforeCreate(){isDef(this.$options.router)?(this._routerRoot=this,this._router=this.$options.router,this._router.init(this),Vue.util.defineReactive(this,"_route",this._router.history.current)):this._routerRoot=this.$parent&&this.$parent._routerRoot||this,registerInstance(this,this)},destroyed:function destroyed(){registerInstance(this)}}),Object.defineProperty(Vue.prototype,"$router",{get:function get(){return this._routerRoot._router}}),Object.defineProperty(Vue.prototype,"$route",{get:function get(){return this._routerRoot._route}}),Vue.component("RouterView",View),Vue.component("RouterLink",Link);var strats=Vue.config.optionMergeStrategies;strats.beforeRouteEnter=strats.beforeRouteLeave=strats.beforeRouteUpdate=strats.created}}var inBrowser="undefined"!=typeof window;function createRouteMap(routes,oldPathList,oldPathMap,oldNameMap,parentRoute){var pathList=oldPathList||[],pathMap=oldPathMap||Object.create(null),nameMap=oldNameMap||Object.create(null);routes.forEach(function(route){addRouteRecord(pathList,pathMap,nameMap,route,parentRoute)});for(var i=0,l=pathList.length;i<l;i++)"*"===pathList[i]&&(pathList.push(pathList.splice(i,1)[0]),l--,i--);var found=pathList.filter(function(path){return path&&"*"!==path.charAt(0)&&"/"!==path.charAt(0)});found.length>0&&warn(!1,"Non-nested routes must include a leading slash character. Fix the following routes: \n"+found.map(function(path){return"- "+path}).join("\n"));return{pathList:pathList,pathMap:pathMap,nameMap:nameMap}}function addRouteRecord(pathList,pathMap,nameMap,route,parent,matchAs){var path=route.path,name=route.name;assert(null!=path,'"path" is required in a route configuration.'),assert("string"!=typeof route.component,'route config "component" for path: '+String(path||name)+" cannot be a string id. Use an actual component instead."),warn(!/[^\u0000-\u007F]+/.test(path),'Route with path "'+path+'" contains unencoded characters, make sure your path is correctly encoded before passing it to the router. Use encodeURI to encode static segments of your path.');var pathToRegexpOptions=route.pathToRegexpOptions||{},normalizedPath=function normalizePath(path,parent,strict){strict||(path=path.replace(/\/$/,""));if("/"===path[0])return path;if(null==parent)return path;return cleanPath(parent.path+"/"+path)}(path,parent,pathToRegexpOptions.strict);"boolean"==typeof route.caseSensitive&&(pathToRegexpOptions.sensitive=route.caseSensitive);var record={path:normalizedPath,regex:compileRouteRegex(normalizedPath,pathToRegexpOptions),components:route.components||{default:route.component},alias:route.alias?"string"==typeof route.alias?[route.alias]:route.alias:[],instances:{},enteredCbs:{},name:name,parent:parent,matchAs:matchAs,redirect:route.redirect,beforeEnter:route.beforeEnter,meta:route.meta||{},props:null==route.props?{}:route.components?route.props:{default:route.props}};if(route.children&&(route.name&&!route.redirect&&route.children.some(function(child){return/^\/?$/.test(child.path)})&&warn(!1,"Named Route '"+route.name+"' has a default child route. When navigating to this named route (:to=\"{name: '"+route.name+"'\"), the default child route will not be rendered. Remove the name from this route and use the name of the default child route for named links instead."),route.children.forEach(function(child){var childMatchAs=matchAs?cleanPath(matchAs+"/"+child.path):void 0;addRouteRecord(pathList,pathMap,nameMap,child,record,childMatchAs)})),pathMap[record.path]||(pathList.push(record.path),pathMap[record.path]=record),void 0!==route.alias)for(var aliases=Array.isArray(route.alias)?route.alias:[route.alias],i=0;i<aliases.length;++i){var alias=aliases[i];if(alias!==path){var aliasRoute={path:alias,children:route.children};addRouteRecord(pathList,pathMap,nameMap,aliasRoute,parent,record.path||"/")}else warn(!1,'Found an alias with the same value as the path: "'+path+'". You have to remove that alias. It will be ignored in development.')}name&&(nameMap[name]?matchAs||warn(!1,'Duplicate named routes definition: { name: "'+name+'", path: "'+record.path+'" }'):nameMap[name]=record)}function compileRouteRegex(path,pathToRegexpOptions){var regex=pathToRegexp_1(path,[],pathToRegexpOptions),keys=Object.create(null);return regex.keys.forEach(function(key){warn(!keys[key.name],'Duplicate param keys in route with path: "'+path+'"'),keys[key.name]=!0}),regex}function createMatcher(routes,router){var ref=createRouteMap(routes),pathList=ref.pathList,pathMap=ref.pathMap,nameMap=ref.nameMap;function match(raw,currentRoute,redirectedFrom){var location=normalizeLocation(raw,currentRoute,!1,router),name=location.name;if(name){var record=nameMap[name];if(warn(record,"Route with name '"+name+"' does not exist"),!record)return _createRoute(null,location);var paramNames=record.regex.keys.filter(function(key){return!key.optional}).map(function(key){return key.name});if("object"!=typeof location.params&&(location.params={}),currentRoute&&"object"==typeof currentRoute.params)for(var key in currentRoute.params)!(key in location.params)&&paramNames.indexOf(key)>-1&&(location.params[key]=currentRoute.params[key]);return location.path=fillParams(record.path,location.params,'named route "'+name+'"'),_createRoute(record,location,redirectedFrom)}if(location.path){location.params={};for(var i=0;i<pathList.length;i++){var path=pathList[i],record$1=pathMap[path];if(matchRoute(record$1.regex,location.path,location.params))return _createRoute(record$1,location,redirectedFrom)}}return _createRoute(null,location)}function redirect(record,location){var originalRedirect=record.redirect,redirect="function"==typeof originalRedirect?originalRedirect(createRoute(record,location,null,router)):originalRedirect;if("string"==typeof redirect&&(redirect={path:redirect}),!redirect||"object"!=typeof redirect)return warn(!1,"invalid redirect option: "+JSON.stringify(redirect)),_createRoute(null,location);var re=redirect,name=re.name,path=re.path,query=location.query,hash=location.hash,params=location.params;if(query=re.hasOwnProperty("query")?re.query:query,hash=re.hasOwnProperty("hash")?re.hash:hash,params=re.hasOwnProperty("params")?re.params:params,name)return assert(nameMap[name],'redirect failed: named route "'+name+'" not found.'),match({_normalized:!0,name:name,query:query,hash:hash,params:params},void 0,location);if(path){var rawPath=function resolveRecordPath(path,record){return resolvePath(path,record.parent?record.parent.path:"/",!0)}(path,record);return match({_normalized:!0,path:fillParams(rawPath,params,'redirect route with path "'+rawPath+'"'),query:query,hash:hash},void 0,location)}return warn(!1,"invalid redirect option: "+JSON.stringify(redirect)),_createRoute(null,location)}function _createRoute(record,location,redirectedFrom){return record&&record.redirect?redirect(record,redirectedFrom||location):record&&record.matchAs?function alias(record,location,matchAs){var aliasedMatch=match({_normalized:!0,path:fillParams(matchAs,location.params,'aliased route with path "'+matchAs+'"')});if(aliasedMatch){var matched=aliasedMatch.matched,aliasedRecord=matched[matched.length-1];return location.params=aliasedMatch.params,_createRoute(aliasedRecord,location)}return _createRoute(null,location)}(0,location,record.matchAs):createRoute(record,location,redirectedFrom,router)}return{match:match,addRoute:function addRoute(parentOrRoute,route){var parent="object"!=typeof parentOrRoute?nameMap[parentOrRoute]:void 0;createRouteMap([route||parentOrRoute],pathList,pathMap,nameMap,parent),parent&&parent.alias.length&&createRouteMap(parent.alias.map(function(alias){return{path:alias,children:[route]}}),pathList,pathMap,nameMap,parent)},getRoutes:function getRoutes(){return pathList.map(function(path){return pathMap[path]})},addRoutes:function addRoutes(routes){createRouteMap(routes,pathList,pathMap,nameMap)}}}function matchRoute(regex,path,params){var m=path.match(regex);if(!m)return!1;if(!params)return!0;for(var i=1,len=m.length;i<len;++i){var key=regex.keys[i-1];key&&(params[key.name||"pathMatch"]="string"==typeof m[i]?decode(m[i]):m[i])}return!0}var Time=inBrowser&&window.performance&&window.performance.now?window.performance:Date;function genStateKey(){return Time.now().toFixed(3)}var _key=genStateKey();function getStateKey(){return _key}function setStateKey(key){return _key=key}var positionStore=Object.create(null);function setupScroll(){"scrollRestoration"in window.history&&(window.history.scrollRestoration="manual");var protocolAndPath=window.location.protocol+"//"+window.location.host,absolutePath=window.location.href.replace(protocolAndPath,""),stateCopy=extend({},window.history.state);return stateCopy.key=getStateKey(),window.history.replaceState(stateCopy,"",absolutePath),window.addEventListener("popstate",handlePopState),function(){window.removeEventListener("popstate",handlePopState)}}function handleScroll(router,to,from,isPop){if(router.app){var behavior=router.options.scrollBehavior;behavior&&(assert("function"==typeof behavior,"scrollBehavior must be a function"),router.app.$nextTick(function(){var position=function getScrollPosition(){var key=getStateKey();if(key)return positionStore[key]}(),shouldScroll=behavior.call(router,to,from,isPop?position:null);shouldScroll&&("function"==typeof shouldScroll.then?shouldScroll.then(function(shouldScroll){scrollToPosition(shouldScroll,position)}).catch(function(err){assert(!1,err.toString())}):scrollToPosition(shouldScroll,position))}))}}function saveScrollPosition(){var key=getStateKey();key&&(positionStore[key]={x:window.pageXOffset,y:window.pageYOffset})}function handlePopState(e){saveScrollPosition(),e.state&&e.state.key&&setStateKey(e.state.key)}function isValidPosition(obj){return isNumber(obj.x)||isNumber(obj.y)}function normalizePosition(obj){return{x:isNumber(obj.x)?obj.x:window.pageXOffset,y:isNumber(obj.y)?obj.y:window.pageYOffset}}function isNumber(v){return"number"==typeof v}var hashStartsWithNumberRE=/^#\d/;function scrollToPosition(shouldScroll,position){var isObject="object"==typeof shouldScroll;if(isObject&&"string"==typeof shouldScroll.selector){var el=hashStartsWithNumberRE.test(shouldScroll.selector)?document.getElementById(shouldScroll.selector.slice(1)):document.querySelector(shouldScroll.selector);if(el){var offset=shouldScroll.offset&&"object"==typeof shouldScroll.offset?shouldScroll.offset:{};position=function getElementPosition(el,offset){var docRect=document.documentElement.getBoundingClientRect(),elRect=el.getBoundingClientRect();return{x:elRect.left-docRect.left-offset.x,y:elRect.top-docRect.top-offset.y}}(el,offset=function normalizeOffset(obj){return{x:isNumber(obj.x)?obj.x:0,y:isNumber(obj.y)?obj.y:0}}(offset))}else isValidPosition(shouldScroll)&&(position=normalizePosition(shouldScroll))}else isObject&&isValidPosition(shouldScroll)&&(position=normalizePosition(shouldScroll));position&&("scrollBehavior"in document.documentElement.style?window.scrollTo({left:position.x,top:position.y,behavior:shouldScroll.behavior}):window.scrollTo(position.x,position.y))}var ua,supportsPushState=inBrowser&&((-1===(ua=window.navigator.userAgent).indexOf("Android 2.")&&-1===ua.indexOf("Android 4.0")||-1===ua.indexOf("Mobile Safari")||-1!==ua.indexOf("Chrome")||-1!==ua.indexOf("Windows Phone"))&&window.history&&"function"==typeof window.history.pushState);function pushState(url,replace){saveScrollPosition();var history=window.history;try{if(replace){var stateCopy=extend({},history.state);stateCopy.key=getStateKey(),history.replaceState(stateCopy,"",url)}else history.pushState({key:setStateKey(genStateKey())},"",url)}catch(e){window.location[replace?"replace":"assign"](url)}}function replaceState(url){pushState(url,!0)}function runQueue(queue,fn,cb){var step=function(index){index>=queue.length?cb():queue[index]?fn(queue[index],function(){step(index+1)}):step(index+1)};step(0)}var NavigationFailureType={redirected:2,aborted:4,cancelled:8,duplicated:16};function createNavigationRedirectedError(from,to){return createRouterError(from,to,NavigationFailureType.redirected,'Redirected when going from "'+from.fullPath+'" to "'+function stringifyRoute(to){if("string"==typeof to)return to;if("path"in to)return to.path;var location={};return propertiesToLog.forEach(function(key){key in to&&(location[key]=to[key])}),JSON.stringify(location,null,2)}(to)+'" via a navigation guard.')}function createNavigationCancelledError(from,to){return createRouterError(from,to,NavigationFailureType.cancelled,'Navigation cancelled from "'+from.fullPath+'" to "'+to.fullPath+'" with a new navigation.')}function createRouterError(from,to,type,message){var error=new Error(message);return error._isRouter=!0,error.from=from,error.to=to,error.type=type,error}var propertiesToLog=["params","query","hash"];function isError(err){return Object.prototype.toString.call(err).indexOf("Error")>-1}function isNavigationFailure(err,errorType){return isError(err)&&err._isRouter&&(null==errorType||err.type===errorType)}function resolveAsyncComponents(matched){return function(to,from,next){var hasAsync=!1,pending=0,error=null;flatMapComponents(matched,function(def,_,match,key){if("function"==typeof def&&void 0===def.cid){hasAsync=!0,pending++;var res,resolve=once(function(resolvedDef){(function isESModule(obj){return obj.__esModule||hasSymbol&&"Module"===obj[Symbol.toStringTag]})(resolvedDef)&&(resolvedDef=resolvedDef.default),def.resolved="function"==typeof resolvedDef?resolvedDef:_Vue.extend(resolvedDef),match.components[key]=resolvedDef,--pending<=0&&next()}),reject=once(function(reason){var msg="Failed to resolve async component "+key+": "+reason;warn(!1,msg),error||(error=isError(reason)?reason:new Error(msg),next(error))});try{res=def(resolve,reject)}catch(e){reject(e)}if(res)if("function"==typeof res.then)res.then(resolve,reject);else{var comp=res.component;comp&&"function"==typeof comp.then&&comp.then(resolve,reject)}}}),hasAsync||next()}}function flatMapComponents(matched,fn){return flatten(matched.map(function(m){return Object.keys(m.components).map(function(key){return fn(m.components[key],m.instances[key],m,key)})}))}function flatten(arr){return Array.prototype.concat.apply([],arr)}var hasSymbol="function"==typeof Symbol&&"symbol"==typeof Symbol.toStringTag;function once(fn){var called=!1;return function(){for(var args=[],len=arguments.length;len--;)args[len]=arguments[len];if(!called)return called=!0,fn.apply(this,args)}}var History=function History(router,base){this.router=router,this.base=function normalizeBase(base){if(!base)if(inBrowser){var baseEl=document.querySelector("base");base=(base=baseEl&&baseEl.getAttribute("href")||"/").replace(/^https?:\/\/[^\/]+/,"")}else base="/";"/"!==base.charAt(0)&&(base="/"+base);return base.replace(/\/$/,"")}(base),this.current=START,this.pending=null,this.ready=!1,this.readyCbs=[],this.readyErrorCbs=[],this.errorCbs=[],this.listeners=[]};function extractGuards(records,name,bind,reverse){var guards=flatMapComponents(records,function(def,instance,match,key){var guard=function extractGuard(def,key){"function"!=typeof def&&(def=_Vue.extend(def));return def.options[key]}(def,name);if(guard)return Array.isArray(guard)?guard.map(function(guard){return bind(guard,instance,match,key)}):bind(guard,instance,match,key)});return flatten(reverse?guards.reverse():guards)}function bindGuard(guard,instance){if(instance)return function boundRouteGuard(){return guard.apply(instance,arguments)}}History.prototype.listen=function listen(cb){this.cb=cb},History.prototype.onReady=function onReady(cb,errorCb){this.ready?cb():(this.readyCbs.push(cb),errorCb&&this.readyErrorCbs.push(errorCb))},History.prototype.onError=function onError(errorCb){this.errorCbs.push(errorCb)},History.prototype.transitionTo=function transitionTo(location,onComplete,onAbort){var route,this$1=this;try{route=this.router.match(location,this.current)}catch(e){throw this.errorCbs.forEach(function(cb){cb(e)}),e}var prev=this.current;this.confirmTransition(route,function(){this$1.updateRoute(route),onComplete&&onComplete(route),this$1.ensureURL(),this$1.router.afterHooks.forEach(function(hook){hook&&hook(route,prev)}),this$1.ready||(this$1.ready=!0,this$1.readyCbs.forEach(function(cb){cb(route)}))},function(err){onAbort&&onAbort(err),err&&!this$1.ready&&(isNavigationFailure(err,NavigationFailureType.redirected)&&prev===START||(this$1.ready=!0,this$1.readyErrorCbs.forEach(function(cb){cb(err)})))})},History.prototype.confirmTransition=function confirmTransition(route,onComplete,onAbort){var this$1=this,current=this.current;this.pending=route;var abort=function(err){!isNavigationFailure(err)&&isError(err)&&(this$1.errorCbs.length?this$1.errorCbs.forEach(function(cb){cb(err)}):(warn(!1,"uncaught error during route navigation:"),console.error(err))),onAbort&&onAbort(err)},lastRouteIndex=route.matched.length-1,lastCurrentIndex=current.matched.length-1;if(isSameRoute(route,current)&&lastRouteIndex===lastCurrentIndex&&route.matched[lastRouteIndex]===current.matched[lastCurrentIndex])return this.ensureURL(),abort(function createNavigationDuplicatedError(from,to){var error=createRouterError(from,to,NavigationFailureType.duplicated,'Avoided redundant navigation to current location: "'+from.fullPath+'".');return error.name="NavigationDuplicated",error}(current,route));var ref=function resolveQueue(current,next){var i,max=Math.max(current.length,next.length);for(i=0;i<max&&current[i]===next[i];i++);return{updated:next.slice(0,i),activated:next.slice(i),deactivated:current.slice(i)}}(this.current.matched,route.matched),updated=ref.updated,deactivated=ref.deactivated,activated=ref.activated,queue=[].concat(function extractLeaveGuards(deactivated){return extractGuards(deactivated,"beforeRouteLeave",bindGuard,!0)}(deactivated),this.router.beforeHooks,function extractUpdateHooks(updated){return extractGuards(updated,"beforeRouteUpdate",bindGuard)}(updated),activated.map(function(m){return m.beforeEnter}),resolveAsyncComponents(activated)),iterator=function(hook,next){if(this$1.pending!==route)return abort(createNavigationCancelledError(current,route));try{hook(route,current,function(to){!1===to?(this$1.ensureURL(!0),abort(function createNavigationAbortedError(from,to){return createRouterError(from,to,NavigationFailureType.aborted,'Navigation aborted from "'+from.fullPath+'" to "'+to.fullPath+'" via a navigation guard.')}(current,route))):isError(to)?(this$1.ensureURL(!0),abort(to)):"string"==typeof to||"object"==typeof to&&("string"==typeof to.path||"string"==typeof to.name)?(abort(createNavigationRedirectedError(current,route)),"object"==typeof to&&to.replace?this$1.replace(to):this$1.push(to)):next(to)})}catch(e){abort(e)}};runQueue(queue,iterator,function(){var enterGuards=function extractEnterGuards(activated){return extractGuards(activated,"beforeRouteEnter",function(guard,_,match,key){return function bindEnterGuard(guard,match,key){return function routeEnterGuard(to,from,next){return guard(to,from,function(cb){"function"==typeof cb&&(match.enteredCbs[key]||(match.enteredCbs[key]=[]),match.enteredCbs[key].push(cb)),next(cb)})}}(guard,match,key)})}(activated);runQueue(enterGuards.concat(this$1.router.resolveHooks),iterator,function(){if(this$1.pending!==route)return abort(createNavigationCancelledError(current,route));this$1.pending=null,onComplete(route),this$1.router.app&&this$1.router.app.$nextTick(function(){handleRouteEntered(route)})})})},History.prototype.updateRoute=function updateRoute(route){this.current=route,this.cb&&this.cb(route)},History.prototype.setupListeners=function setupListeners(){},History.prototype.teardown=function teardown(){this.listeners.forEach(function(cleanupListener){cleanupListener()}),this.listeners=[],this.current=START,this.pending=null};var HTML5History=function(History){function HTML5History(router,base){History.call(this,router,base),this._startLocation=getLocation(this.base)}return History&&(HTML5History.__proto__=History),HTML5History.prototype=Object.create(History&&History.prototype),HTML5History.prototype.constructor=HTML5History,HTML5History.prototype.setupListeners=function setupListeners(){var this$1=this;if(!(this.listeners.length>0)){var router=this.router,expectScroll=router.options.scrollBehavior,supportsScroll=supportsPushState&&expectScroll;supportsScroll&&this.listeners.push(setupScroll());var handleRoutingEvent=function(){var current=this$1.current,location=getLocation(this$1.base);this$1.current===START&&location===this$1._startLocation||this$1.transitionTo(location,function(route){supportsScroll&&handleScroll(router,route,current,!0)})};window.addEventListener("popstate",handleRoutingEvent),this.listeners.push(function(){window.removeEventListener("popstate",handleRoutingEvent)})}},HTML5History.prototype.go=function go(n){window.history.go(n)},HTML5History.prototype.push=function push(location,onComplete,onAbort){var this$1=this,fromRoute=this.current;this.transitionTo(location,function(route){pushState(cleanPath(this$1.base+route.fullPath)),handleScroll(this$1.router,route,fromRoute,!1),onComplete&&onComplete(route)},onAbort)},HTML5History.prototype.replace=function replace(location,onComplete,onAbort){var this$1=this,fromRoute=this.current;this.transitionTo(location,function(route){replaceState(cleanPath(this$1.base+route.fullPath)),handleScroll(this$1.router,route,fromRoute,!1),onComplete&&onComplete(route)},onAbort)},HTML5History.prototype.ensureURL=function ensureURL(push){if(getLocation(this.base)!==this.current.fullPath){var current=cleanPath(this.base+this.current.fullPath);push?pushState(current):replaceState(current)}},HTML5History.prototype.getCurrentLocation=function getCurrentLocation(){return getLocation(this.base)},HTML5History}(History);function getLocation(base){var path=window.location.pathname,pathLowerCase=path.toLowerCase(),baseLowerCase=base.toLowerCase();return!base||pathLowerCase!==baseLowerCase&&0!==pathLowerCase.indexOf(cleanPath(baseLowerCase+"/"))||(path=path.slice(base.length)),(path||"/")+window.location.search+window.location.hash}var HashHistory=function(History){function HashHistory(router,base,fallback){History.call(this,router,base),fallback&&function checkFallback(base){var location=getLocation(base);if(!/^\/#/.test(location))return window.location.replace(cleanPath(base+"/#"+location)),!0}(this.base)||ensureSlash()}return History&&(HashHistory.__proto__=History),HashHistory.prototype=Object.create(History&&History.prototype),HashHistory.prototype.constructor=HashHistory,HashHistory.prototype.setupListeners=function setupListeners(){var this$1=this;if(!(this.listeners.length>0)){var expectScroll=this.router.options.scrollBehavior,supportsScroll=supportsPushState&&expectScroll;supportsScroll&&this.listeners.push(setupScroll());var handleRoutingEvent=function(){var current=this$1.current;ensureSlash()&&this$1.transitionTo(getHash(),function(route){supportsScroll&&handleScroll(this$1.router,route,current,!0),supportsPushState||replaceHash(route.fullPath)})},eventType=supportsPushState?"popstate":"hashchange";window.addEventListener(eventType,handleRoutingEvent),this.listeners.push(function(){window.removeEventListener(eventType,handleRoutingEvent)})}},HashHistory.prototype.push=function push(location,onComplete,onAbort){var this$1=this,fromRoute=this.current;this.transitionTo(location,function(route){pushHash(route.fullPath),handleScroll(this$1.router,route,fromRoute,!1),onComplete&&onComplete(route)},onAbort)},HashHistory.prototype.replace=function replace(location,onComplete,onAbort){var this$1=this,fromRoute=this.current;this.transitionTo(location,function(route){replaceHash(route.fullPath),handleScroll(this$1.router,route,fromRoute,!1),onComplete&&onComplete(route)},onAbort)},HashHistory.prototype.go=function go(n){window.history.go(n)},HashHistory.prototype.ensureURL=function ensureURL(push){var current=this.current.fullPath;getHash()!==current&&(push?pushHash(current):replaceHash(current))},HashHistory.prototype.getCurrentLocation=function getCurrentLocation(){return getHash()},HashHistory}(History);function ensureSlash(){var path=getHash();return"/"===path.charAt(0)||(replaceHash("/"+path),!1)}function getHash(){var href=window.location.href,index=href.indexOf("#");return index<0?"":href=href.slice(index+1)}function getUrl(path){var href=window.location.href,i=href.indexOf("#");return(i>=0?href.slice(0,i):href)+"#"+path}function pushHash(path){supportsPushState?pushState(getUrl(path)):window.location.hash=path}function replaceHash(path){supportsPushState?replaceState(getUrl(path)):window.location.replace(getUrl(path))}var AbstractHistory=function(History){function AbstractHistory(router,base){History.call(this,router,base),this.stack=[],this.index=-1}return History&&(AbstractHistory.__proto__=History),AbstractHistory.prototype=Object.create(History&&History.prototype),AbstractHistory.prototype.constructor=AbstractHistory,AbstractHistory.prototype.push=function push(location,onComplete,onAbort){var this$1=this;this.transitionTo(location,function(route){this$1.stack=this$1.stack.slice(0,this$1.index+1).concat(route),this$1.index++,onComplete&&onComplete(route)},onAbort)},AbstractHistory.prototype.replace=function replace(location,onComplete,onAbort){var this$1=this;this.transitionTo(location,function(route){this$1.stack=this$1.stack.slice(0,this$1.index).concat(route),onComplete&&onComplete(route)},onAbort)},AbstractHistory.prototype.go=function go(n){var this$1=this,targetIndex=this.index+n;if(!(targetIndex<0||targetIndex>=this.stack.length)){var route=this.stack[targetIndex];this.confirmTransition(route,function(){var prev=this$1.current;this$1.index=targetIndex,this$1.updateRoute(route),this$1.router.afterHooks.forEach(function(hook){hook&&hook(route,prev)})},function(err){isNavigationFailure(err,NavigationFailureType.duplicated)&&(this$1.index=targetIndex)})}},AbstractHistory.prototype.getCurrentLocation=function getCurrentLocation(){var current=this.stack[this.stack.length-1];return current?current.fullPath:"/"},AbstractHistory.prototype.ensureURL=function ensureURL(){},AbstractHistory}(History),VueRouter=function VueRouter(options){void 0===options&&(options={}),this.app=null,this.apps=[],this.options=options,this.beforeHooks=[],this.resolveHooks=[],this.afterHooks=[],this.matcher=createMatcher(options.routes||[],this);var mode=options.mode||"hash";switch(this.fallback="history"===mode&&!supportsPushState&&!1!==options.fallback,this.fallback&&(mode="hash"),inBrowser||(mode="abstract"),this.mode=mode,mode){case"history":this.history=new HTML5History(this,options.base);break;case"hash":this.history=new HashHistory(this,options.base,this.fallback);break;case"abstract":this.history=new AbstractHistory(this,options.base);break;default:assert(!1,"invalid mode: "+mode)}},prototypeAccessors={currentRoute:{configurable:!0}};function registerHook(list,fn){return list.push(fn),function(){var i=list.indexOf(fn);i>-1&&list.splice(i,1)}}return VueRouter.prototype.match=function match(raw,current,redirectedFrom){return this.matcher.match(raw,current,redirectedFrom)},prototypeAccessors.currentRoute.get=function(){return this.history&&this.history.current},VueRouter.prototype.init=function init(app){var this$1=this;if(assert(install.installed,"not installed. Make sure to call `Vue.use(VueRouter)` before creating root instance."),this.apps.push(app),app.$once("hook:destroyed",function(){var index=this$1.apps.indexOf(app);index>-1&&this$1.apps.splice(index,1),this$1.app===app&&(this$1.app=this$1.apps[0]||null),this$1.app||this$1.history.teardown()}),!this.app){this.app=app;var history=this.history;if(history instanceof HTML5History||history instanceof HashHistory){var setupListeners=function(routeOrError){history.setupListeners(),function(routeOrError){var from=history.current,expectScroll=this$1.options.scrollBehavior;supportsPushState&&expectScroll&&"fullPath"in routeOrError&&handleScroll(this$1,routeOrError,from,!1)}(routeOrError)};history.transitionTo(history.getCurrentLocation(),setupListeners,setupListeners)}history.listen(function(route){this$1.apps.forEach(function(app){app._route=route})})}},VueRouter.prototype.beforeEach=function beforeEach(fn){return registerHook(this.beforeHooks,fn)},VueRouter.prototype.beforeResolve=function beforeResolve(fn){return registerHook(this.resolveHooks,fn)},VueRouter.prototype.afterEach=function afterEach(fn){return registerHook(this.afterHooks,fn)},VueRouter.prototype.onReady=function onReady(cb,errorCb){this.history.onReady(cb,errorCb)},VueRouter.prototype.onError=function onError(errorCb){this.history.onError(errorCb)},VueRouter.prototype.push=function push(location,onComplete,onAbort){var this$1=this;if(!onComplete&&!onAbort&&"undefined"!=typeof Promise)return new Promise(function(resolve,reject){this$1.history.push(location,resolve,reject)});this.history.push(location,onComplete,onAbort)},VueRouter.prototype.replace=function replace(location,onComplete,onAbort){var this$1=this;if(!onComplete&&!onAbort&&"undefined"!=typeof Promise)return new Promise(function(resolve,reject){this$1.history.replace(location,resolve,reject)});this.history.replace(location,onComplete,onAbort)},VueRouter.prototype.go=function go(n){this.history.go(n)},VueRouter.prototype.back=function back(){this.go(-1)},VueRouter.prototype.forward=function forward(){this.go(1)},VueRouter.prototype.getMatchedComponents=function getMatchedComponents(to){var route=to?to.matched?to:this.resolve(to).route:this.currentRoute;return route?[].concat.apply([],route.matched.map(function(m){return Object.keys(m.components).map(function(key){return m.components[key]})})):[]},VueRouter.prototype.resolve=function resolve(to,current,append){var location=normalizeLocation(to,current=current||this.history.current,append,this),route=this.match(location,current),fullPath=route.redirectedFrom||route.fullPath,href=function createHref(base,fullPath,mode){var path="hash"===mode?"#"+fullPath:fullPath;return base?cleanPath(base+"/"+path):path}(this.history.base,fullPath,this.mode);return{location:location,route:route,href:href,normalizedTo:location,resolved:route}},VueRouter.prototype.getRoutes=function getRoutes(){return this.matcher.getRoutes()},VueRouter.prototype.addRoute=function addRoute(parentOrRoute,route){this.matcher.addRoute(parentOrRoute,route),this.history.current!==START&&this.history.transitionTo(this.history.getCurrentLocation())},VueRouter.prototype.addRoutes=function addRoutes(routes){warn(!1,"router.addRoutes() is deprecated and has been removed in Vue Router 4. Use router.addRoute() instead."),this.matcher.addRoutes(routes),this.history.current!==START&&this.history.transitionTo(this.history.getCurrentLocation())},Object.defineProperties(VueRouter.prototype,prototypeAccessors),VueRouter.install=install,VueRouter.version="3.5.2",VueRouter.isNavigationFailure=isNavigationFailure,VueRouter.NavigationFailureType=NavigationFailureType,VueRouter.START_LOCATION=START,inBrowser&&window.Vue&&window.Vue.use(VueRouter),VueRouter});
