<?php

define( 'BKAP_ICALREADER_VERSION', '0.7.0' );

/**
 * A simple iCal parser. Should take care of most stuff for ya
 * http://github.com/fangel/SG-iCalendar
 *
 * Roadmap:
 *  * Finish FREQUENCY-parsing.
 *  * Add API for recurring events
 *
 * A simple example:
 * <?php
 * $ical = new SG_iCalReader("http://example.com/calendar.ics");
 * foreach( $ical->getEvents() As $event ) {
 *   // Do stuff with the event $event
 * }
 * ?>
 *
 * @package SG_iCalReader
 * @author Morten Fangel (C) 2008
 * @author xonev (C) 2010
 * @author Tanguy Pruvot (C) 2010
 * @license http://creativecommons.org/licenses/by-sa/2.5/dk/deed.en_GB CC-BY-SA-DK
 */
class BKAP_iCal {

	// objects
	public $information; // SG_iCal_VCalendar
	public $timezones;   // SG_iCal_VTimeZone

	protected $events; // SG_iCal_VEvent[]
	protected $error_message = '';

	/**
	 * Constructs a new iCalReader. You can supply the url now, or later using setUrl
	 *
	 * @param $url string
	 */
	public function __construct( $url = false ) {
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Line.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Duration.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Freq.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Recurrence.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Parser.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Query.php'; // BUILD: Remove line
		require_once dirname( __FILE__ ) . '/helper/SG_iCal_Factory.php'; // BUILD: Remove line

		$this->setUrl( $url );
	}

	/**
	 * Sets (or resets) the url this reader reads from.
	 *
	 * @param $url string
	 */
	public function setUrl( $url = false ) {
		if ( $url !== false ) {
			$content = SG_iCal_Parser::Parse( $url, $this );

			if ( is_array( $content ) && isset( $content[0] ) ) {
				if ( false !== strpos( $content[0], '301 Moved Permanently' ) ) {
					$this->error_message = __( 'An error was encountered while trying to fetch the iCal address. Please confirm that the calendar has been set to public or use the "Secret address in iCal format" address link.', 'woocommerce-booking' );
				}
			}
		}
	}

	/**
	 * Returns the main calendar info. You can then query the returned
	 * object with ie getTitle().
	 *
	 * @return SG_iCal_VCalendar
	 */
	public function getCalendarInfo() {
		return $this->information;
	}

	/**
	 * Sets the calendar info for this calendar
	 *
	 * @param SG_iCal_VCalendar $info
	 */
	public function setCalendarInfo( SG_iCal_VCalendar $info ) {
		$this->information = $info;
	}


	/**
	 * Returns a given timezone for the calendar. This is mainly used
	 * by VEvents to adjust their date-times if they have specified a
	 * timezone.
	 *
	 * If no timezone is given, all timezones in the calendar is
	 * returned.
	 *
	 * @param $tzid string
	 * @return SG_iCal_VTimeZone
	 */
	public function getTimeZoneInfo( $tzid = null ) {
		if ( $tzid == null ) {
			return $this->timezones;
		} else {
			if ( ! isset( $this->timezones ) ) {
				return null;
			}
			foreach ( $this->timezones as $tz ) {
				if ( $tz->getTimeZoneId() == $tzid ) {
					return $tz;
				}
			}
			return null;
		}
	}

	/**
	 * Adds a new timezone to this calendar
	 *
	 * @param SG_iCal_VTimeZone $tz
	 */
	public function addTimeZone( SG_iCal_VTimeZone $tz ) {
		$this->timezones[] = $tz;
	}

	/**
	 * Returns the events found
	 *
	 * @return array
	 */
	public function getEvents() {
		return $this->events;
	}

	/**
	 * Returns the errors found
	 *
	 * @return array
	 */
	public function errorMessage() {
		return $this->error_message;
	}

	/**
	 * Adds a event to this calendar
	 *
	 * @param SG_iCal_VEvent $event
	 */
	public function addEvent( SG_iCal_VEvent $event ) {
		$this->events[] = $event;
	}
}

/**
 * Change the name to BKAP_iCalReader to avoid conflicts..
 */
class BKAP_iCalReader extends BKAP_iCal {}
