<?php
/**
 * Bookings and Appointment Plugin for WooCommerce
 *
 * Template for Bookings Only Date Setting. This template shall be resued on Cart, Checkout and My Account Pages
 *
 * @author      Tyche Softwares
 * @package     Bookings and Appointment Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ( isset( $booking_settings['booking_fixed_block_enable'] ) && 'yes' !== $booking_settings['booking_fixed_block_enable'] ) || ! isset( $booking_settings['booking_fixed_block_enable'] ) ) {
	?>
<div id="bkap-booking-form" class="bkap-booking-form bkap-multiple-dayts-time">
	<?php
}

do_action( 'bkap_before_booking_form', $product_id, $booking_settings, $hidden_dates );
$method_to_show = 'bkap_check_for_time_slot';
$get_method     = bkap_common::bkap_ajax_on_select_date( $product_id );

if ( isset( $get_method ) && 'multiple_time' === $get_method ) {
	$method_to_show = apply_filters( 'bkap_function_slot', '' );
}

// fetch specific booking dates.
$booking_dates_arr = array();
if ( isset( $booking_settings['booking_specific_date'] ) ) {
	$booking_dates_arr = $booking_settings['booking_specific_date'];
}

$booking_dates_str = '';
if ( isset( $booking_settings['booking_specific_booking'] ) && 'on' === $booking_settings['booking_specific_booking'] ) {
	if ( ! empty( $booking_dates_arr ) ) {
		foreach ( $booking_dates_arr as $k => $v ) {
			$booking_dates_str .= '"' . $k . '",';
		}
	}
	$booking_dates_str = substr( $booking_dates_str, 0, strlen( $booking_dates_str ) - 1 );
}

?>
	<input type="hidden" name="wapbk_booking_dates" id="wapbk_booking_dates" value='<?php echo esc_attr( $booking_dates_str ); ?>'>
	<?php
	// Display the stock div above the dates.
	$availability_display = false;
	if ( isset( $global_settings->booking_availability_display ) && 'on' === $global_settings->booking_availability_display ) {
		$total_stock_message  = bkap_total_stock_message( $booking_settings, $product_id, $booking_type );
		$availability_display = true;
	}

	$calendar_icon_file = get_option( 'bkap_calendar_icon_file' );
	$calendar_src       = '';
	if ( '' !== $calendar_icon_file && 'none' !== $calendar_icon_file ) {
		$calendar_src = plugins_url() . '/woocommerce-booking/assets/images/' . $calendar_icon_file;
	} elseif ( 'none' !== $calendar_icon_file ) {
		$calendar_src = plugins_url() . '/woocommerce-booking/assets/images/calendar1.gif';
	}

	$calendar_src = apply_filters( 'bkap_calendar_icon_file', $calendar_src, $product_id, $booking_settings );

	$disabled        = '';
	$disabled_status = apply_filters( 'bkap_disable_booking_fields', false, $product_id );
	if ( $disabled_status && '' !== bkap_common::bkap_date_from_session_cookie( 'start_date' ) ) {
		$disabled     = 'style="pointer-events:none;"';
		$calendar_src = '';
	}

	$is_inline    = isset( $booking_settings['enable_inline_calendar'] ) && 'on' === $booking_settings['enable_inline_calendar'] ? true : false;
	$is_list_view = ( isset( $global_settings->booking_timeslot_display_mode ) && 'list-view' === $global_settings->booking_timeslot_display_mode ) ? true : false;

	do_action( 'bkap_before_availability_message', $product_id, $booking_settings, $booking_type );

	if ( true === $availability_display && 'multiple_days_time' !== $booking_type ) {
		?>
	<div id="bkap_show_stock_status" name="show_stock_status" class="bkap_show_stock_status">
		<?php echo wp_kses_post( $total_stock_message ); ?>
	</div>
		<?php
	}

	do_action( 'bkap_after_availability_message', $product_id, $booking_settings, $booking_type );

	$display_start = apply_filters( 'bkap_check_to_show_start_date_field', true, $product_id, $booking_settings, $hidden_dates, $global_settings );
	$booking_type  = bkap_type( $product_id );

	$show_dropdown = false;
	if ( isset( $booking_settings['bkap_date_in_dropdown'] ) && 'on' === $booking_settings['bkap_date_in_dropdown'] && isset( $booking_type ) && ! in_array( $booking_type, array( 'multiple_days' ) ) ) {

		$bkap_weekdays       = bkap_weekdays();
		$date_array          = array();
		$date_formats        = bkap_date_formats();
		$date_format_set     = $date_formats[ $global_settings->booking_date_format ];
		$lockout_dates       = $hidden_dates['additional_data']['wapbk_lockout_days'];
		$lockout_dates_array = array_map(
			'trim',
			explode( ',', str_replace( '"', '', $lockout_dates ) )
		);

		$select_date = apply_filters( 'bkap_choose_date_dropdown_option', __( 'Choose a date', 'woocommerce-booking' ), $product_id );

		if ( isset( $hidden_dates['additional_data']['specific_dates'] ) && '' != $hidden_dates['additional_data']['specific_dates'] ) {
			$specific_dates_str   = $hidden_dates['additional_data']['specific_dates'];
			$specific_dates_array = explode( ',', $specific_dates_str );
			$specific_array       = array();

			foreach ( $specific_dates_array as $key => $value ) {
				$value = trim( $value, '"' );
				array_push( $specific_array, $value );
			}
			$date_array = array_merge( $date_array, $specific_array );
		}

		if ( isset( $booking_type ) && '' !== $booking_type ) {
			$max_days_display = $booking_settings['booking_maximum_number_days'];

			if ( $max_days_display > 50 ) {
				$max_days_display = apply_filters( 'bkap_modify_maximum_number_days', $max_days_display );
			}

			$start_date = gmdate( 'j-n-Y', strtotime( $hidden_dates['additional_data']['default_date'] ) );

			if ( 'on' === $booking_settings['booking_recurring_booking'] ) {
				$singleday_array = array();

				$fixed_range = false;
				if ( isset( $hidden_dates['additional_data']['fixed_ranges'] ) && '' !== $hidden_dates['additional_data']['fixed_ranges'] ) {
					$fixed_range    = true;
					$fixed_ranges   = str_replace( '"', '', $hidden_dates['additional_data']['fixed_ranges'] );
					$explode_ranges = explode( ',', $fixed_ranges );
					$ranges         = array_chunk( $explode_ranges, 2 );
					foreach ( $ranges as $key => $value ) {
						$dates           = bkap_common::bkap_get_betweendays( $value[0], $value[1], 'j-n-Y', $booking_settings['booking_recurring'] );
						$singleday_array = array_merge( $singleday_array, $dates );
					}
				} else {
					$max_booking_date = calback_bkap_max_date( $hidden_dates['additional_data']['default_date'], $max_days_display, $booking_settings );
					$singleday_array  = bkap_common::bkap_get_betweendays( $start_date, $max_booking_date, 'j-n-Y', $booking_settings['booking_recurring'] );
				}

				$date_array = array_merge( $date_array, $singleday_array );
			}
		}

		usort(
			$date_array,
			function ( $a, $b ) {
				return strtotime( $a ) - strtotime( $b );
			}
		);

		$date_array     = array_unique( $date_array );
		$holiday_string = $hidden_dates['additional_data']['holidays'];
		$holidays       = explode( ',', $holiday_string );
		$min_date       = strtotime( $start_date );

		$dates_in_dropdown = array();
		foreach ( $date_array as $date_range_key => $date_range_value ) {
			$date           = strtotime( trim( $date_range_value, '"' ) );
			$lockout_compare = gmdate( 'j-n-Y', strtotime( $date_range_value ) );

			if ( $min_date <= $date ) {
				if ( ! in_array( $lockout_compare, $lockout_dates_array ) ) {
					if ( ! in_array( '"' . $date_range_value . '"', $holidays, true ) ) {
						$dates_in_dropdown[ $date_range_key ] = $date_range_value;
					}
				}
			}
		}

		if ( empty( $dates_in_dropdown ) ) {
			bkap_unavailable_for_booking();
			$display_start = false;
		} else {
			$show_dropdown = true;
		}
	}

	if ( $display_start ) {
		if ( 'multiple_days_time' === $booking_type  ) {
			printf( '<div class="bkap_start_date_time_selection">' );
		}
		?>
	<div class="bkap_start_date" id="bkap_start_date" <?php echo esc_attr( $disabled ); ?>>
		<label class="book_start_date_label" style="margin-top:1em;">
			<?php
				$bkap_start_date_label = get_option( 'book_date-label', __( 'Start Date', 'woocommerce-booking' ) );
				$bkap_start_date_label = apply_filters( 'bkap_change_start_date_label', $bkap_start_date_label, $booking_settings, $product_id );
				echo esc_html( $bkap_start_date_label );
			?>
		</label>
			<?php
			/**
			 * Show dates in dropdown.
			 */
			if ( $show_dropdown ) {
				printf( '<select name="booking_calender" id="booking_calender" class="bkap_date_dropdown">' );
				printf( '<option value="">%s</option>', esc_attr( $select_date ) );
				foreach ( $dates_in_dropdown as $date_range_key => $date_range_value ) {
					$date            = strtotime( trim( $date_range_value, '"' ) );
					$check_in_date   = date_i18n( $date_format_set, $date );
					$lockout_compare = gmdate( 'j-n-Y', strtotime( $date_range_value ) );
					$selected        = $lockout_compare === $hidden_dates['hidden_date'] ? 'selected' : '';
					printf( '<option value="%s" %s>%s</option>', esc_attr( $date_range_value ), esc_attr( $selected ), esc_attr( $check_in_date ) );
				}
				printf( '</select><br/>' );
			} else {

				printf( '<input type="text" id="booking_calender" name="booking_calender" class="booking_calender" style="cursor: text!important;" readonly />' );

				if ( ! $is_inline && '' !== $calendar_src ) {
					printf( '<img src="%s" style="cursor:pointer!important;width: 20px;height: 20px;" id="checkin_cal" />', esc_url( $calendar_src ) );
				}

				if ( $is_inline ) {
					printf( '<div id="inline_calendar"></div>' );
				}
			}
			?>
	</div>
		<?php
	}

	?>
	<?php
		if ( ( isset( $booking_settings['booking_enable_time'] ) &&
				in_array( $booking_settings['booking_enable_time'], array( 'on', 'dates_time' ), true ) &&
				isset( $booking_settings['booking_time_settings'] ) )
				|| ( isset( $booking_settings['booking_enable_time'] ) &&
				'duration_time' === $booking_settings['booking_enable_time'] &&
				isset( $booking_settings['bkap_duration_settings'] )
				)
			) {
			?>
	<div id="show_time_slot" name="show_time_slot" class="show_time_slot">
		<label id="bkap_book_time">
			<?php
				$bkap_book_time_label = get_option( 'book_time-label', __( 'Booking Time', 'woocommerce-booking' ) );
				$bkap_book_time_label = apply_filters( 'bkap_change_book_time_label', $bkap_book_time_label, $booking_settings, $product_id );
				echo wp_kses_post( $bkap_book_time_label );
			?>
		</label><br />
			<?php
			if ( ! $is_inline ) :
				?>
		<div id="cadt">
				<?php
					$bkap_change_cadt = __( 'Choose a date above to see available time slots.', 'woocommerce-booking' );
					echo wp_kses_post( apply_filters( 'bkap_change_cadt', $bkap_change_cadt, $product_id ) );
				?>
		</div>
		<?php endif; ?>
	</div>
	<?php } ?>

	<?php
	if ( $is_list_view && 'multiple_days_time' !== $booking_type ) {
		if ( ! isset( $booking_settings['booking_enable_multiple_time'] ) || ( isset( $booking_settings['booking_enable_multiple_time'] ) && 'multiple' !== $booking_settings['booking_enable_multiple_time'] ) ) {
			printf( '<input type="hidden" name="time_slot" id="time_slot" value="" />' );
		}
	}

	/* Multiple Days & Time : Start Time Dropdown */
	if ( 'multiple_days_time' === $booking_type ) {
		$additional_start_time_css_class = '';
		if ( $is_list_view ) {
			$additional_start_time_css_class = 'show_time_slot';
		} elseif ( isset( $booking_settings['booking_multiple_days_time_block_type'] ) && 'selected_slots' === $booking_settings['booking_multiple_days_time_block_type'] ) {
			$additional_start_time_css_class = 'bkap-stack-vertical';
		}
		?>
	<div id="bkap_start_time_slot_section" name="bkap_start_time_slot_section" class="bkap_start_time_slot_section <?php echo $additional_start_time_css_class; // phpcs:ignore ?>">
		<label id="bkap_start_time_label">
		<?php
			$bkap_book_time_label = get_option( 'book_start_time-label', __( 'Start Time', 'woocommerce-booking' ) );
			$bkap_book_time_label = apply_filters( 'bkap_change_start_time_label', $bkap_book_time_label, $booking_settings, $product_id );
			echo wp_kses_post( $bkap_book_time_label );
		?>
		</label>
		<?php if ( ! $is_list_view ) { ?>
			<select id="bkap_start_time" style="display:none;"></select>
		<?php } ?>
	</div>
		<?php
		if ( ! $is_inline ) :
			?>
		<div id="bkap_start_time_message">
			<?php
				$bkap_change_cadt = __( 'Choose start date to see available time slots.', 'woocommerce-booking' );
				echo wp_kses_post( apply_filters( 'bkap_change_start_time_message', $bkap_change_cadt, $product_id ) );
			?>
		</div>
		<?php endif; ?>
	<?php } ?>
	<?php
	if ( $is_list_view ) {
		printf( '<input type="hidden" name="bkap_start_time" id="bkap_start_time" value="" />' );
	}

	if ( 'multiple_days_time' === $booking_type  ) {
		printf( '</div>' ); // bkap_start_date_time_selection div ends.
	}

	if ( ( isset( $booking_settings['booking_enable_multiple_day'] ) && 'on' === $booking_settings['booking_enable_multiple_day'] ) || ( 'multiple_days_time' === $booking_type ) ) {
		if ( 'multiple_days_time' === $booking_type ) {
			printf( '<div class="bkap_end_date_time_selection bkap-disable-section">' );
		}
		?>
	<div class="bkap_end_date" id="bkap_end_date" <?php echo esc_attr( $disabled ); ?>>
		<label class="book_end_date_label">
			<?php
				$bkap_end_date_label = get_option( 'checkout_date-label', __( 'End Date', 'woocommerce-booking' ) );
				$bkap_end_date_label = apply_filters( 'bkap_change_end_date_label', $bkap_end_date_label, $booking_settings, $product_id );
				echo wp_kses_post( $bkap_end_date_label );
			?>
		</label>
		<input type="text" id="booking_calender_checkout" name="booking_calender_checkout" class="booking_calender"
			style="cursor: text!important;" readonly />
			<?php
			if ( ! $is_inline && '' !== $calendar_src ) {
				?>
			<img src="<?php echo esc_url( $calendar_src ); ?>" style="cursor:pointer!important;width: 20px;height: 20px;" id="checkout_cal" />
				<?php
			}
			if ( $is_inline ) {
				?>
		<div id="inline_calendar_checkout"></div>
		<?php } ?>
	</div>
		<?php
	}

	/* Multiple Days & Time : End Time Dropdown */
	if ( 'multiple_days_time' === $booking_type ) {
		?>
		<div id="bkap_end_time_slot_section" name="bkap_end_time_slot_section" class="bkap_end_time_slot_section <?php echo $additional_start_time_css_class; // phpcs:ignore ?>">
			<label id="bkap_end_time_label">
		<?php
			$bkap_book_time_label = get_option( 'book_end_time-label', __( 'End Time', 'woocommerce-booking' ) );
			$bkap_book_time_label = apply_filters( 'bkap_change_end_time_label', $bkap_book_time_label, $booking_settings, $product_id );
			echo wp_kses_post( $bkap_book_time_label );
		?>
			</label>
			<select id="bkap_end_time" style="display:none;"></select>
		</div>
		<?php
		if ( ! $is_inline ) :
			?>
			<div id="bkap_end_time_message" style="display:none;">
				<?php
					$bkap_change_cadt = __( 'Choose end date above to see available time slots.', 'woocommerce-booking' );
					echo wp_kses_post( apply_filters( 'bkap_change_end_time_message', $bkap_change_cadt, $product_id ) );
				?>
			</div>
		<?php endif; ?>
	<?php } ?>

	<?php
	if ( $is_list_view ) {
		printf( '<input type="hidden" name="bkap_end_time" id="bkap_end_time" value="" />' );
	}

	if ( 'multiple_days_time' === $booking_type  ) {
		printf( '</div>' ); // bkap_end_date_time_selection div ends.
	}

	if ( ! isset( $booking_settings['booking_enable_multiple_day'] ) || ( isset( $booking_settings['booking_enable_multiple_day'] ) && 'on' !== $booking_settings['booking_enable_multiple_day'] ) ) {
		do_action( 'bkap_display_price_div', $product_id, $booking_settings );
	}
	do_action( 'bkap_before_add_to_cart_button', $booking_settings, $product_id );

	?>
	<div class="bkap-form-error"></div>
</div>
