<?php

  function mfrh_replace_urls_recursive( $data, $old_url, $new_url, $old_filename, $new_filename ) {
    if ( is_string( $data ) ) {
      // Replace both full URLs and filenames
      return str_replace( array( $old_url, $old_filename ), array( $new_url, $new_filename ), $data );
    } elseif ( is_array( $data ) ) {
      foreach ( $data as $key => $value ) {
        $data[$key] = mfrh_replace_urls_recursive( $value, $old_url, $new_url, $old_filename, $new_filename );
      }
    } elseif ( is_object( $data ) ) {
      foreach ( $data as $key => $value ) {
        $data->$key = mfrh_replace_urls_recursive( $value, $old_url, $new_url, $old_filename, $new_filename );
      }
    }
    
    return $data;
  }

  add_action( 'mfrh_url_renamed', 'mfrh_woocommerce', 10, 3 );

  function mfrh_woocommerce( $post, $orig_image_url, $new_image_url ) {
    global $wpdb, $mfrh_core;


    //Beaver Builder stores the image URL in the postmeta table with the following format:
    //s:10:"image.jpg";
    //s:60:"https://www.example.com/wp-content/uploads/2021/01/image.jpg";
    //We need to replace the old URL and Filename with the new ones and keep the same string length.

    // Build the full URLs with site URL and upload path
    $uploads         = wp_upload_dir();
    $uploads_baseurl = trailingslashit( $uploads['baseurl'] );
    
    $full_orig_url   = $uploads_baseurl . $orig_image_url;
    $full_new_url    = $uploads_baseurl . $new_image_url;
    
    // Extract just the filenames (without path)
    $orig_filename   = basename( $orig_image_url );
    $new_filename    = basename( $new_image_url );
    
    // Find serialized data patterns and replace with correct string length
    $query = $wpdb->prepare(
      "SELECT post_id, meta_id, meta_value FROM $wpdb->postmeta 
       WHERE meta_key = '_downloadable_files'
       AND (meta_value LIKE %s OR meta_value LIKE %s)",
      '%' . $wpdb->esc_like( $full_orig_url ) . '%',
      '%' . $wpdb->esc_like( $orig_filename ) . '%'
    );
    
    $results = $wpdb->get_results( $query );
    
    if ( $results ) {

      foreach ( $results as $row ) {
        $meta_value = $row->meta_value;
        
        // Create a backup for revert operations
        $orig_meta = $meta_value;
        
        // Unserialize the data to work with it properly
        $unserialized_data = maybe_unserialize( $meta_value );
        
        if ( $unserialized_data ) {
          // Recursively replace URLs and filenames in the data
          $updated_data = mfrh_replace_urls_recursive( $unserialized_data, $full_orig_url, $full_new_url, $orig_filename, $new_filename );
          
          // Serialize the data back
          $new_meta_value = maybe_serialize( $updated_data );
          
          // Update the meta value if changed
          if ( $new_meta_value !== $orig_meta ) {
            $wpdb->update(
              $wpdb->postmeta,
              array( 'meta_value' => $new_meta_value ),
              array( 'meta_id'    => $row->meta_id )
            );
            
            // Create revert data
            $revert_data = mfrh_replace_urls_recursive( $updated_data, $full_new_url, $full_orig_url, $new_filename, $orig_filename );
            $revert_meta_value = maybe_serialize( $revert_data );
            
            $query = $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = %s WHERE meta_id = %d", 
                      $new_meta_value, $row->meta_id );
            $query_revert = $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = %s WHERE meta_id = %d", 
                             $revert_meta_value, $row->meta_id );
            
            $mfrh_core->log_sql( $query, $query_revert );
            $mfrh_core->log("WooCommerce downloadable files updated: URLs and filenames replaced in unserialized data.");
          }
        }
      }
    }

  }

?>