jQuery(document).ready(function () {

    jQuery('.um-reviews-avg').um_raty({
        half: true,
        starType: 'i',
        number: function () {
            return jQuery(this).attr('data-number');
        },
        score: function () {
            return jQuery(this).attr('data-score');
        },
        hints: ['1 Star', '2 Star', '3 Star', '4 Star', '5 Star'],
        space: false,
        readOnly: true
    });

    jQuery('.um-reviews-rate').um_raty({
        half: false,
        starType: 'i',
        number: function () {
            return jQuery(this).attr('data-number');
        },
        score: function () {
            return jQuery(this).attr('data-score');
        },
        scoreName: function () {
            return jQuery(this).attr('data-key');
        },
        hints: ['1 Star', '2 Star', '3 Star', '4 Star', '5 Star'],
        space: false
    });
    resizeDoc();
});
jQuery(window).on('resize orientationchange', function () {
    resizeDoc();
});


jQuery( document ).ajaxSuccess( function( event, xhr, settings ) {
	if ( 'undefined' !== typeof settings.data && settings.data.indexOf('post_type=um_review') >= 0 && settings.data.indexOf('action=inline-save') >= 0 ) {
		jQuery('.um-reviews-avg').um_raty({
			half: true,
			starType: 'i',
			number: function () {
				return jQuery(this).attr('data-number');
			},
			score: function () {
				return jQuery(this).attr('data-score');
			},
			hints: ['1 Star', '2 Star', '3 Star', '4 Star', '5 Star'],
			space: false,
			readOnly: true
		});
	}
});


/**
 * Get user avatar for "From" and "To" fields in the "This Review" metabox
 * @author Alex
 * @since 2019-08-01
 */
jQuery('.um-form-review .um-forms-line select').on('change', function (e) {
	var img = jQuery(e.target).parent().find('img').first();
	var id = jQuery(this).val();
	wp.ajax.send( 'um_reviews_get_avatar', {
		data: {
			user_id: id
		},
		success: function( data ) {
			img.attr('alt', data.alt || '');
			img.attr('src', data.url);
			img.attr('title', data.alt || '');
		},
		error: function( e ) {
			console.log( 'UM Reviews script error:', e );
		}
	});
});


/**
 * This function works at boot time "jQuery(document).ready()" and at events "resize orientationchange"
 **/
function resizeDoc() {
    var bw = jQuery("body").width();
    /**
     * It puts the "Name" column to the top and in the end
     **/
    if (bw <= 782) {
        jQuery('.post-type-um_review thead tr,.post-type-um_review tbody tr,.post-type-um_review tfoot tr').each(function (i, element) {
            jQuery('.column-review_from', jQuery(element)).before(jQuery('.column-title', jQuery(element)));
        });
    }

}
