<?php
/**
 * New renewal email to vendor.
 *
 * @since 2.1.70
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$order_date         = $order->get_date_created();
$billing_first_name = $order->get_billing_first_name();
$billing_last_name  = $order->get_billing_last_name();

do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p>
	<?php
	printf(
		// translators: %s: customer name.
		esc_html__( 'You have received a subscription renewal order from %s. The subscription renewal order is as follows:',
			'woocommerce-product-vendors' ),
		esc_html( $billing_first_name ) . ' ' . esc_html( $billing_last_name ) );
	?>
</p>

<h2>
	<?php
	// translators: %s: order number.
	printf( esc_html__( 'Order #%s', 'woocommerce-product-vendors' ), esc_html( $order->get_order_number() ) ); ?> (<?php
	// translators: %s: order date.
	printf(
		'<time datetime="%s">%s</time>',
		esc_html( date_i18n( 'c', strtotime( $order_date ) ) ),
		esc_html( date_i18n( wc_date_format(), strtotime( $order_date ) ) ) ); ?>)
</h2>

<?php $email->render_order_details_table( $order, $sent_to_admin, $plain_text, $email, $this_vendor ); ?>

<?php do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'wc_product_vendors_email_order_meta', $order, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_footer', $email ); ?>
